/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.quadtree;

import java.util.Collection;
import java.util.function.Function;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.quadtree.ForceObject;
import org.jungrapht.visualization.layout.quadtree.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarnesHutQuadTree<T> {
    private static final Logger log = LoggerFactory.getLogger(BarnesHutQuadTree.class);
    private Node<T> root;
    private final Object lock = new Object();

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public Rectangle getBounds() {
        return this.root.getBounds();
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public BarnesHutQuadTree() {
        this(BarnesHutQuadTree.builder());
    }

    private BarnesHutQuadTree(Builder<T> builder) {
        this.root = Node.builder().withArea(builder.bounds).withTheta(builder.theta).build();
    }

    public void clear() {
        this.root.clear();
    }

    public void applyForcesTo(ForceObject<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Cannot apply forces to a null ForceObject");
        }
        if (this.root != null && this.root.forceObject != visitor) {
            this.root.applyForcesTo(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(ForceObject node) {
        Object object = this.lock;
        synchronized (object) {
            this.root.insert(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(Collection<T> elements, Function<T, Point> locations) {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            elements.forEach(element -> this.insert(new ForceObject<Object>(element, (Point)locations.apply(element))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(Collection<T> elements, Function<T, Double> masses, Function<T, Point> locations) {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            elements.forEach(element -> this.insert(new ForceObject<Object>(element, (Point)locations.apply(element), (double)((Double)masses.apply(element)))));
        }
    }

    public String toString() {
        return "Tree:" + this.root;
    }

    public static class Builder<T> {
        protected double theta = 0.5;
        protected Rectangle bounds;

        public Builder bounds(Rectangle bounds) {
            this.bounds = bounds;
            return this;
        }

        public Builder bounds(double x, double y, double width, double height) {
            this.bounds(new Rectangle(x, y, width, height));
            return this;
        }

        public Builder bounds(double width, double height) {
            this.bounds(new Rectangle(0.0, 0.0, width, height));
            return this;
        }

        public Builder theta(double theta) {
            this.theta = theta;
            return this;
        }

        public BarnesHutQuadTree<T> build() {
            return new BarnesHutQuadTree(this);
        }
    }
}

