/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tree;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.tree.ProgramTreeMergePanel;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class ProgramTreeMergeManager
implements MergeResolver {
    private static String[] PROGRAM_TREE_PHASE = new String[]{"Program Trees"};
    static final String NAME_PANEL_ID = "Name Panel";
    static final String CONFLICTS_PANEL_ID = "Name/Content Conflicts Panel";
    private Program resultProgram;
    private Program originalProgram;
    private ProgramChangeSet myChangeSet;
    private ProgramChangeSet latestChangeSet;
    private TaskMonitor currentMonitor;
    private Listing myListing;
    private Listing resultListing;
    private Listing latestListing;
    private ArrayList<Long> conflictsChangeList;
    private int conflictOption;
    private ProgramMultiUserMergeManager mergeManager;
    private ProgramTreeMergePanel mergePanel;
    private int progressIndex;
    private int onlyNamesChangedChoice = -1;
    private int onlyDestinationStructureChoice = -1;
    private int onlySourceStructureChoice = -1;
    private int bothStructuresChangedChoice = -1;
    static final int CANCELED = -2;
    static final int ASK_USER = -1;
    static final int KEEP_OTHER_NAME = 0;
    static final int KEEP_PRIVATE_NAME = 1;
    static final int ADD_NEW_TREE = 2;
    static final int RENAME_PRIVATE = 3;
    static final int ORIGINAL_NAME = 4;

    public ProgramTreeMergeManager(ProgramMultiUserMergeManager mergeManager, Program resultProgram, Program myProgram, Program originalProgram, Program latestProgram, ProgramChangeSet latestChangeSet, ProgramChangeSet myChangeSet) {
        this.mergeManager = mergeManager;
        this.resultProgram = resultProgram;
        this.originalProgram = originalProgram;
        this.latestChangeSet = latestChangeSet;
        this.myChangeSet = myChangeSet;
        this.myListing = myProgram.getListing();
        this.resultListing = resultProgram.getListing();
        this.latestListing = latestProgram.getListing();
        this.conflictOption = -1;
    }

    @Override
    public void apply() {
        this.conflictOption = this.mergePanel.getSelectedOption();
    }

    @Override
    public void cancel() {
        this.conflictOption = -2;
    }

    @Override
    public String getDescription() {
        return "Merge Program Trees";
    }

    @Override
    public String getName() {
        return "Program Tree Merger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(PROGRAM_TREE_PHASE);
        this.currentMonitor = monitor;
        long[] myChangeIDs = this.myChangeSet.getProgramTreeChanges();
        long[] myIDsAdded = this.myChangeSet.getProgramTreeAdditions();
        long[] latestChangeIDs = this.latestChangeSet.getProgramTreeChanges();
        long[] latestIDsAdded = this.latestChangeSet.getProgramTreeAdditions();
        this.mergeManager.updateProgress(0, "Program Tree Merge is processing IDs changed in Checked Out...");
        ArrayList<Long> changeList = new ArrayList<Long>();
        for (long myChangeID : myChangeIDs) {
            changeList.add(myChangeID);
        }
        this.mergeManager.updateProgress(10, "Program Tree Merge is processing IDs added in Checked Out...");
        ArrayList<Long> myAddedList = new ArrayList<Long>();
        for (long element : myIDsAdded) {
            myAddedList.add(element);
        }
        this.mergeManager.updateProgress(20, "Program Tree Merge is eliminating removed IDs...");
        changeList.removeAll(myAddedList);
        this.mergeManager.updateProgress(30, "Program Tree Merge is processing IDs added in Latest...");
        ArrayList<Long> latestAddedList = new ArrayList<Long>();
        for (long element : latestIDsAdded) {
            latestAddedList.add(element);
        }
        this.conflictsChangeList = new ArrayList(changeList);
        this.mergeManager.updateProgress(40, "Program Tree Merge is processing change IDs...");
        ArrayList<Long> latestChangeList = new ArrayList<Long>();
        for (long latestChangeID : latestChangeIDs) {
            latestChangeList.add(latestChangeID);
        }
        this.mergeManager.updateProgress(50, "Program Tree Merge is finding changes to apply automatically...");
        changeList.removeAll(latestChangeList);
        this.mergeManager.updateProgress(60, "Program Tree Merge is finding conflicting IDs...");
        this.conflictsChangeList.retainAll(latestChangeList);
        monitor.setMaximum((long)(myAddedList.size() + changeList.size() + this.conflictsChangeList.size()));
        int transactionID = this.resultProgram.startTransaction("Merge Program Trees");
        boolean commit = false;
        try {
            this.mergeManager.updateProgress(70, "Program Tree Merge is applying additions...");
            this.applyAdditions(myAddedList);
            this.mergeManager.updateProgress(80, "Program Tree Merge is applying changes...");
            this.applyChanges(changeList);
            this.mergeManager.updateProgress(90, "Program Tree Merge is processing conflicts...");
            this.processConflicts(this.conflictsChangeList);
            this.mergeManager.updateProgress(100, "Done merging program trees");
            commit = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.resultProgram.endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(PROGRAM_TREE_PHASE);
    }

    void setConflictResolution(int option) {
        this.conflictOption = option;
    }

    private void applyAdditions(ArrayList<Long> myList) throws CancelledException {
        for (Long element : myList) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long treeID = element;
            ProgramModule sourceRoot = this.myListing.getRootModule(treeID);
            if (sourceRoot == null) continue;
            this.createTree(this.resultListing, this.getUniqueTreeName(sourceRoot.getTreeName()), sourceRoot);
        }
    }

    private String getUniqueTreeName(String baseName) {
        return ProgramTreeMergeManager.getUniqueTreeName(this.resultProgram, baseName);
    }

    static String getUniqueTreeName(Program program, String baseName) {
        Listing currentListing = program.getListing();
        if (currentListing.getRootModule((String)baseName) == null) {
            return baseName;
        }
        int oneUpNumber = 0;
        String userName = SystemUtilities.getUserName();
        Object name = baseName = (String)baseName + "." + userName;
        while (currentListing.getRootModule((String)name) != null) {
            name = (String)baseName + ++oneUpNumber;
        }
        return name;
    }

    private void applyChanges(ArrayList<Long> changeList) throws CancelledException {
        for (Long element : changeList) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long treeID = element;
            ProgramModule sourceRoot = this.myListing.getRootModule(treeID);
            ProgramModule destRoot = this.resultListing.getRootModule(treeID);
            if (sourceRoot == null) {
                if (destRoot == null) continue;
                this.resultListing.removeTree(destRoot.getTreeName());
                continue;
            }
            if (destRoot != null) {
                String sourceTreeName = sourceRoot.getTreeName();
                String destTreeName = destRoot.getTreeName();
                if (destTreeName.equals(sourceTreeName)) {
                    this.resultListing.removeTree(sourceTreeName);
                    this.createTree(this.resultListing, this.getUniqueTreeName(sourceTreeName), sourceRoot);
                    continue;
                }
                if (!this.treeStructureChanged(treeID)) {
                    try {
                        this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(sourceTreeName));
                        continue;
                    }
                    catch (DuplicateNameException e1) {
                        throw new AssertException();
                    }
                }
                ProgramModule originalRoot = this.originalProgram.getListing().getRootModule(treeID);
                if (sourceRoot.getModificationNumber() != originalRoot.getModificationNumber()) {
                    this.resultListing.removeTree(destTreeName);
                }
                this.createTree(this.resultListing, this.getUniqueTreeName(sourceTreeName), sourceRoot);
                continue;
            }
            this.createTree(this.resultListing, this.getUniqueTreeName(sourceRoot.getTreeName()), sourceRoot);
        }
    }

    private boolean treeStructureChanged(long treeID) {
        ProgramModule sourceRoot = this.myListing.getRootModule(treeID);
        ProgramModule destRoot = this.resultListing.getRootModule(treeID);
        ProgramModule originalRoot = this.originalProgram.getListing().getRootModule(treeID);
        long sourceModNumber = sourceRoot.getModificationNumber();
        return destRoot != null && destRoot.getModificationNumber() != sourceModNumber || originalRoot != null && originalRoot.getModificationNumber() != sourceModNumber;
    }

    private boolean treeStructureChanged(ProgramModule root1, ProgramModule root2) {
        if (root1 == null) {
            return true;
        }
        return root1.getModificationNumber() != root2.getModificationNumber();
    }

    private long createTree(Listing listing, String treeName, ProgramModule sourceRoot) {
        ArrayList<String> fragmentNameList = new ArrayList<String>();
        try {
            ProgramModule root = listing.createRootModule(treeName);
            Group[] kids = root.getChildren();
            String[] names = new String[kids.length];
            for (int i = 0; i < kids.length; ++i) {
                names[i] = kids[i].getName() + "__default__" + i;
                kids[i].setName(names[i]);
            }
            this.createModules(root, sourceRoot, fragmentNameList);
            this.removeEmptyFragments(root, fragmentNameList);
            for (String name : names) {
                root.removeChild(name);
            }
            return root.getTreeID();
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Got duplicate name while creating tree " + treeName);
        }
        catch (NotEmptyException e) {
            throw new AssertException("Got Not empty exception");
        }
    }

    private void removeEmptyFragments(ProgramModule module, ArrayList<String> fragmentNameList) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (group instanceof ProgramFragment) {
                String name = group.getName();
                if (fragmentNameList.contains(name)) continue;
                try {
                    module.removeChild(name);
                    continue;
                }
                catch (NotEmptyException e) {
                    throw new AssertException("Could not remove " + name + ": " + String.valueOf((Object)e));
                }
            }
            this.removeEmptyFragments((ProgramModule)group, fragmentNameList);
        }
    }

    private void createModules(ProgramModule parent, ProgramModule sourceParent, ArrayList<String> fragmentNameList) {
        Group[] kids;
        parent.setComment(sourceParent.getComment());
        for (Group kid : kids = sourceParent.getChildren()) {
            if (this.currentMonitor.isCancelled()) {
                return;
            }
            String name = kid.getName();
            if (kid instanceof ProgramModule) {
                this.createModule(parent, name, (ProgramModule)kid, fragmentNameList);
                continue;
            }
            this.createFragment(parent, name, (ProgramFragment)kid, fragmentNameList);
        }
    }

    private void createModule(ProgramModule parent, String name, ProgramModule sourceModule, ArrayList<String> fragmentNameList) {
        ProgramModule m = null;
        try {
            m = parent.createModule(name);
        }
        catch (DuplicateNameException e) {
            m = this.resultProgram.getListing().getModule(parent.getTreeName(), name);
            try {
                parent.add(m);
            }
            catch (CircularDependencyException exc) {
                throw new AssertException("Could not add " + name + " to " + parent.getName() + ": " + String.valueOf((Object)e));
            }
            catch (DuplicateGroupException duplicateGroupException) {
                // empty catch block
            }
        }
        this.createModules(m, sourceModule, fragmentNameList);
    }

    private void createFragment(ProgramModule parent, String name, ProgramFragment sourceFrag, ArrayList<String> fragmentNameList) {
        if (!fragmentNameList.contains(name)) {
            fragmentNameList.add(name);
        }
        ProgramFragment newFrag = null;
        try {
            newFrag = parent.createFragment(name);
            newFrag.setComment(sourceFrag.getComment());
        }
        catch (DuplicateNameException e) {
            newFrag = this.resultProgram.getListing().getFragment(parent.getTreeName(), name);
            try {
                parent.add(newFrag);
            }
            catch (DuplicateGroupException duplicateGroupException) {
                // empty catch block
            }
        }
        if (!sourceFrag.isEmpty()) {
            ArrayList<AddressRange> list = new ArrayList<AddressRange>();
            AddressRangeIterator iter = sourceFrag.getAddressRanges();
            while (iter.hasNext()) {
                list.add((AddressRange)iter.next());
            }
            for (AddressRange range : list) {
                try {
                    newFrag.move(range.getMinAddress(), range.getMaxAddress());
                }
                catch (NotFoundException e1) {
                    throw new AssertException("Address range " + String.valueOf(range.getMinAddress()) + " to " + String.valueOf(range.getMaxAddress()) + " not found!");
                }
            }
        }
    }

    private void processConflicts(ArrayList<Long> list) throws CancelledException {
        for (int i = 0; i < list.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long treeID = list.get(i);
            ProgramModule myRoot = this.myListing.getRootModule(treeID);
            ProgramModule resultRoot = this.resultListing.getRootModule(treeID);
            ProgramModule origRoot = this.originalProgram.getListing().getRootModule(treeID);
            ProgramModule latestRoot = this.latestListing.getRootModule(treeID);
            String myTreeName = null;
            String resultTreeName = null;
            String latestTreeName = null;
            String origTreeName = origRoot.getTreeName();
            if (myRoot != null) {
                myTreeName = myRoot.getTreeName();
            }
            if (resultRoot != null) {
                resultTreeName = resultRoot.getTreeName();
            }
            if (latestRoot != null) {
                latestTreeName = latestRoot.getTreeName();
            }
            if (resultRoot == null && myRoot == null || resultRoot != null && myRoot == null) continue;
            if (resultRoot == null && myRoot != null) {
                if (!this.nameChanged(origRoot, myTreeName) && !this.treeStructureChanged(origRoot, myRoot)) continue;
                this.createTree(this.resultListing, myTreeName, myRoot);
                continue;
            }
            if (!this.treeStructureChanged(treeID) && this.nameChanged(origRoot, myTreeName) && this.nameChanged(origRoot, resultTreeName)) {
                this.namesChanged(myRoot, resultRoot, origRoot, i + 1);
                continue;
            }
            if (this.treeStructureChanged(origRoot, latestRoot) && this.treeStructureChanged(origRoot, myRoot)) {
                this.keepOtherOrCreateTree(origRoot, myRoot, resultRoot, i + 1);
                continue;
            }
            if (this.nameChanged(origRoot, latestTreeName) && this.treeStructureChanged(origRoot, latestRoot) && this.nameChanged(origRoot, myTreeName)) {
                this.namesContentChanged(myRoot, myTreeName, resultTreeName, origRoot, i + 1);
                continue;
            }
            if (this.nameChanged(origRoot, latestTreeName) && this.nameChanged(origRoot, myTreeName) && this.treeStructureChanged(origRoot, myRoot)) {
                this.nameContentsChanged(myRoot, myTreeName, resultTreeName, origTreeName, i + 1);
                continue;
            }
            if (this.nameChanged(origRoot, latestTreeName) && this.treeStructureChanged(origRoot, myRoot)) {
                this.resultListing.removeTree(resultTreeName);
                this.createTree(this.resultListing, resultTreeName, myRoot);
                continue;
            }
            if (!this.nameChanged(origRoot, myTreeName) || !this.treeStructureChanged(origRoot, latestRoot)) continue;
            try {
                this.resultListing.renameTree(resultTreeName, this.getUniqueTreeName(myTreeName));
                continue;
            }
            catch (DuplicateNameException e) {
                throw new AssertException("Got duplicate name");
            }
        }
    }

    private void keepOtherOrCreateTree(ProgramModule origRoot, ProgramModule sourceRoot, ProgramModule destRoot, int conflictIndex) throws CancelledException {
        String sourceTreeName = sourceRoot.getTreeName();
        String destTreeName = destRoot.getTreeName();
        String origTreeName = origRoot.getTreeName();
        boolean destChanged = this.treeStructureChanged(origRoot, destRoot);
        if (this.bothStructuresChangedChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.showMergePanel(CONFLICTS_PANEL_ID, conflictIndex, destTreeName, sourceTreeName, origTreeName, this.nameChanged(origRoot, destTreeName), destChanged, this.nameChanged(origRoot, sourceTreeName), this.treeStructureChanged(origRoot, sourceRoot));
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
            if (this.mergePanel.getUseForAll()) {
                this.bothStructuresChangedChoice = this.conflictOption;
            }
        }
        int optionToUse = this.bothStructuresChangedChoice == -1 ? this.conflictOption : this.bothStructuresChangedChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 2: 
            case 3: {
                this.createTree(this.resultListing, this.getUniqueTreeName(sourceTreeName), sourceRoot);
                break;
            }
            case 4: {
                if (destChanged) {
                    this.createTree(this.resultListing, this.getUniqueTreeName(origTreeName), origRoot);
                    break;
                }
                try {
                    this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(origTreeName));
                    break;
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
            }
        }
        this.conflictOption = -1;
    }

    private void namesChanged(ProgramModule sourceRoot, ProgramModule destRoot, ProgramModule origRoot, int conflictIndex) throws CancelledException {
        String sourceTreeName = sourceRoot.getTreeName();
        String destTreeName = destRoot.getTreeName();
        String origTreeName = origRoot.getTreeName();
        if (this.onlyNamesChangedChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.waitForUserInput(sourceTreeName, destTreeName, origTreeName, conflictIndex, true, false, true, false);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
            if (this.mergePanel.getUseForAll()) {
                this.onlyNamesChangedChoice = this.conflictOption;
            }
        }
        int optionToUse = this.onlyNamesChangedChoice == -1 ? this.conflictOption : this.onlyNamesChangedChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(sourceTreeName));
                }
                catch (DuplicateNameException duplicateNameException) {}
                break;
            }
            case 2: {
                this.createTree(this.resultListing, sourceTreeName, sourceRoot);
                break;
            }
            case 3: {
                try {
                    this.resultListing.renameTree(sourceTreeName, this.getUniqueTreeName(sourceTreeName));
                }
                catch (DuplicateNameException duplicateNameException) {}
                break;
            }
            case 4: {
                try {
                    this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(origTreeName));
                }
                catch (DuplicateNameException duplicateNameException) {}
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
        this.conflictOption = -1;
    }

    private void waitForUserInput(String sourceTreeName, String destTreeName, String origTreeName, int conflictIndex, boolean latestNameChanged, boolean latestStructureChanged, boolean privNameChanged, boolean privStructureChanged) {
        String panelID = NAME_PANEL_ID;
        if (this.resultListing.getRootModule(sourceTreeName) != null) {
            panelID = CONFLICTS_PANEL_ID;
        }
        this.showMergePanel(panelID, conflictIndex, destTreeName, sourceTreeName, origTreeName, latestNameChanged, latestStructureChanged, privNameChanged, privStructureChanged);
    }

    private void namesContentChanged(ProgramModule sourceRoot, String sourceTreeName, String destTreeName, ProgramModule origRoot, int conflictIndex) throws CancelledException {
        String origTreeName = origRoot.getTreeName();
        if (this.onlyDestinationStructureChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.waitForUserInput(sourceTreeName, destTreeName, origTreeName, conflictIndex, true, true, true, false);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
            if (this.mergePanel.getUseForAll()) {
                this.onlyDestinationStructureChoice = this.conflictOption;
            }
        }
        int optionToUse = this.onlyDestinationStructureChoice == -1 ? this.conflictOption : this.onlyDestinationStructureChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(sourceTreeName));
                    break;
                }
                catch (DuplicateNameException e) {
                    throw new AssertException("Got duplicate name exception!");
                }
            }
            case 2: 
            case 3: {
                this.createTree(this.resultListing, this.getUniqueTreeName(sourceTreeName), sourceRoot);
                break;
            }
            case 4: {
                this.createTree(this.resultListing, this.getUniqueTreeName(origTreeName), origRoot);
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
        this.conflictOption = -1;
    }

    private void nameContentsChanged(ProgramModule sourceRoot, String sourceTreeName, String destTreeName, String origTreeName, int conflictIndex) throws CancelledException {
        if (this.onlySourceStructureChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.waitForUserInput(sourceTreeName, destTreeName, origTreeName, conflictIndex, true, false, true, true);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
            if (this.mergePanel.getUseForAll()) {
                this.onlySourceStructureChoice = this.conflictOption;
            }
        }
        int optionToUse = this.onlySourceStructureChoice == -1 ? this.conflictOption : this.onlySourceStructureChoice;
        switch (optionToUse) {
            case 0: {
                this.resultListing.removeTree(destTreeName);
                this.createTree(this.resultListing, destTreeName, sourceRoot);
                break;
            }
            case 1: {
                this.resultListing.removeTree(destTreeName);
                this.createTree(this.resultListing, sourceTreeName, sourceRoot);
                break;
            }
            case 2: {
                this.createTree(this.resultListing, sourceTreeName, sourceRoot);
                break;
            }
            case 3: {
                this.createTree(this.resultListing, this.getUniqueTreeName(sourceTreeName), sourceRoot);
                break;
            }
            case 4: {
                try {
                    this.resultListing.renameTree(destTreeName, this.getUniqueTreeName(origTreeName));
                }
                catch (DuplicateNameException duplicateNameException) {}
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
        this.conflictOption = -1;
    }

    private boolean nameChanged(ProgramModule origRoot, String treeName) {
        return !origRoot.getTreeName().equals(treeName);
    }

    private void showMergePanel(final String panelID, final int conflictIndex, final String name1, final String name2, final String origName, final boolean latestNameChanged, final boolean latestStructureChanged, final boolean privNameChanged, final boolean privStructureChanged) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ProgramTreeMergeManager.this.mergePanel == null) {
                        ProgramTreeMergeManager.this.mergePanel = new ProgramTreeMergePanel(ProgramTreeMergeManager.this.mergeManager, ProgramTreeMergeManager.this.conflictsChangeList.size());
                    }
                    ProgramTreeMergeManager.this.mergePanel.setConflictInfo(panelID, conflictIndex, ProgramTreeMergeManager.this.resultProgram, name1, name2, origName, latestNameChanged, latestStructureChanged, privNameChanged, privStructureChanged);
                    this.setConflictDetails();
                }

                private void setConflictDetails() {
                    String conflictDetails = latestStructureChanged ? (privStructureChanged ? " where both the Latest and the Checked Out tree structures were changed" : " where only the Latest tree structure was changed") : (privStructureChanged ? " where only the Checked Out tree structure was changed" : " where only the tree names were changed");
                    ProgramTreeMergeManager.this.mergePanel.setConflictDetails(conflictDetails);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent(this.mergePanel, "ProgramTreeMerge", new HelpLocation("Repository", "ProgramTreeConflict"));
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{PROGRAM_TREE_PHASE};
    }
}

