/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ReorderManager;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.exception.NotFoundException;

class DnDMoveManager {
    private ProgramDnDTree tree;
    private ReorderManager reorderDDMgr;

    DnDMoveManager(ProgramDnDTree tree) {
        this.tree = tree;
        this.reorderDDMgr = new ReorderManager(tree);
    }

    boolean isDropSiteOk(ProgramNode destinationNode, ProgramNode[] dropNodes, int dropAction, int relativeMousePos) {
        for (int i = 0; i < dropNodes.length; ++i) {
            if (this.canDropNode(destinationNode, dropNodes[i], dropAction, relativeMousePos)) continue;
            return false;
        }
        return true;
    }

    private boolean canDropNode(ProgramNode destinationNode, ProgramNode dropNode, int dropAction, int relativeMousePosition) {
        Group dragGroup = dropNode.getGroup();
        if (dragGroup.equals((Object)destinationNode.getGroup())) {
            return false;
        }
        if (relativeMousePosition != 0) {
            return this.reorderDDMgr.isDropSiteOk(destinationNode, dropNode, dropAction, relativeMousePosition);
        }
        if (destinationNode.isFragment()) {
            return this.checkDestFragment(destinationNode, dropNode, dropAction);
        }
        ProgramModule destModule = destinationNode.getModule();
        if (dropNode.isFragment() && destModule.contains(dropNode.getFragment())) {
            return false;
        }
        if (dropNode.isModule()) {
            ProgramModule dropModule = dropNode.getModule();
            if (destModule.contains(dropNode.getModule())) {
                return false;
            }
            if (dropModule.isDescendant(destModule)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ProgramNode destNode, ProgramNode[] dropNodes, int dropAction, int relativeMousePos) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        if (relativeMousePos != 0) {
            this.reorderDDMgr.add(destNode, dropNodes, dropAction, relativeMousePos);
            return;
        }
        String operation = dropAction == 2 ? "Move" : "Copy";
        int transactionID = this.tree.startTransaction(operation);
        if (transactionID < 0) {
            return;
        }
        try {
            for (int i = 0; i < dropNodes.length; ++i) {
                boolean ok = true;
                if (destNode.isFragment()) {
                    ok = this.addToFragment(destNode, dropNodes[i]);
                } else {
                    this.addToModule(destNode, dropNodes[i], dropAction);
                }
                if (!ok) continue;
                this.tree.addSelectionPath(destNode.getTreePath());
            }
        }
        finally {
            this.tree.endTransaction(transactionID, true);
        }
    }

    private boolean checkDestFragment(ProgramNode destNode, ProgramNode dropNode, int dropAction) {
        if (dropAction != 2) {
            return false;
        }
        if (dropNode.isFragment()) {
            return true;
        }
        ProgramModule dropModule = dropNode.getModule();
        return !dropModule.isDescendant(destNode.getFragment());
    }

    private boolean addToFragment(ProgramNode destNode, ProgramNode dropNode) {
        ProgramFragment destFrag = destNode.getFragment();
        try {
            this.tree.mergeGroup(dropNode.getGroup(), destFrag);
            this.tree.removeSelectionPath(dropNode.getTreePath());
            return true;
        }
        catch (Exception e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"Error Moving Fragments", (Throwable)e);
            return false;
        }
    }

    private void addToModule(ProgramNode destNode, ProgramNode dropNode, int dropAction) throws DuplicateGroupException, NotFoundException, CircularDependencyException {
        ProgramNode newnode;
        ProgramModule destModule = destNode.getModule();
        ProgramModule parentModule = dropNode.getParentModule();
        if (!destNode.wasVisited()) {
            this.tree.visitNode(destNode);
        }
        if (dropNode.isFragment()) {
            ProgramFragment fragment = dropNode.getFragment();
            if (dropAction == 1) {
                destModule.add(fragment);
            } else {
                destModule.reparent(fragment.getName(), parentModule);
            }
        } else {
            ProgramModule module = dropNode.getModule();
            if (dropAction == 1) {
                destModule.add(module);
            } else {
                destModule.reparent(module.getName(), parentModule);
            }
            if (this.tree.isExpanded(destNode.getTreePath())) {
                this.tree.groupAdded((Group)module);
            }
        }
        if (this.tree.isExpanded(destNode.getTreePath()) && (newnode = this.tree.getChild(destNode, dropNode.getName())) != null) {
            this.tree.matchExpansionState(dropNode, newnode);
        }
    }
}

