/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.util.SymbolInspector;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;

public class SymbolRenderer
extends GhidraTableCellRenderer {
    private SymbolInspector inspector;

    public void setSymbolInspector(SymbolInspector inspector) {
        this.inspector = inspector;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        int column = data.getColumnModelIndex();
        if (value == null && column == 0) {
            this.setText("<< REMOVED >>");
        } else if (value instanceof Symbol) {
            Symbol s = (Symbol)value;
            this.setBold();
            Color color = this.inspector.getColor(s);
            if (!data.isSelected()) {
                this.setForeground(color);
            }
        }
        return this;
    }
}

