/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.StandardElfInfoProducer;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import java.io.IOException;

public class GnuDebugLink
implements ElfInfoItem {
    public static final String SECTION_NAME = ".gnu_debuglink";
    private final int filenameLen;
    private final String filename;
    private final int crc;

    public static GnuDebugLink fromProgram(Program program) {
        ElfInfoItem.ItemWithAddress<GnuDebugLink> wrappedItem = ElfInfoItem.readItemFromSection(program, SECTION_NAME, GnuDebugLink::read);
        return wrappedItem != null ? wrappedItem.item() : null;
    }

    public static GnuDebugLink read(BinaryReader br, Program program) {
        try {
            long filenameStart = br.getPointerIndex();
            String filename = br.readNextAsciiString();
            br.align(4);
            int filenameLen = (int)(br.getPointerIndex() - filenameStart);
            int crc = br.readNextInt();
            return new GnuDebugLink(filenameLen, filename, crc);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public GnuDebugLink(int filenameLen, String filename, int crc) {
        this.filenameLen = filenameLen;
        this.filename = filename;
        this.crc = crc;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getFilenameLen() {
        return this.filenameLen;
    }

    public int getCrc() {
        return this.crc;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        program.getOptions("Program Information").setString("GNU DebugLink", this.getFilename());
        try {
            StructureDataType struct = this.toStructure((DataTypeManager)program.getDataTypeManager());
            if (struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup GnuDebugLink at %s: %s".formatted(address, this));
        }
    }

    private StructureDataType toStructure(DataTypeManager dtm) {
        if (this.filenameLen <= 0) {
            return null;
        }
        StructureDataType result = new StructureDataType(StandardElfInfoProducer.ELF_CATEGORYPATH, "GnuDebugLink_%d".formatted(this.filenameLen), 0, dtm);
        result.add((DataType)StringDataType.dataType, this.filenameLen, "filename", null);
        result.add(StructConverter.DWORD, "crc", null);
        return result;
    }

    public String toString() {
        return String.format("GnuDebugLink [filename=%s, crc=%s]", this.filename, this.crc);
    }
}

