/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import ghidra.app.util.opinion.LoadSpec;
import ghidra.program.model.lang.LanguageCompilerSpecPair;

public class BatchGroupLoadSpec
implements Comparable<BatchGroupLoadSpec> {
    public LanguageCompilerSpecPair lcsPair;
    public boolean preferred;

    public BatchGroupLoadSpec(LoadSpec loadSpec) {
        this.lcsPair = loadSpec.getLanguageCompilerSpec();
        this.preferred = loadSpec.isPreferred();
    }

    public String toString() {
        return (this.lcsPair != null ? this.lcsPair.toString() : "none") + (this.preferred ? "*" : "");
    }

    public boolean matches(LoadSpec loadSpec) {
        return loadSpec.getLanguageCompilerSpec() == this.lcsPair || loadSpec.getLanguageCompilerSpec() != null && loadSpec.getLanguageCompilerSpec().equals((Object)this.lcsPair);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lcsPair == null ? 0 : this.lcsPair.hashCode());
        result = 31 * result + (this.preferred ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGroupLoadSpec)) {
            return false;
        }
        BatchGroupLoadSpec other = (BatchGroupLoadSpec)obj;
        if (this.lcsPair == null ? other.lcsPair != null : !this.lcsPair.equals((Object)other.lcsPair)) {
            return false;
        }
        return this.preferred == other.preferred;
    }

    @Override
    public int compareTo(BatchGroupLoadSpec o) {
        String s1 = this.toString();
        String s2 = o.toString();
        return s1.compareTo(s2);
    }
}

