/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.List;

public class RegisterTree
implements Comparable<RegisterTree> {
    private static final String SEPARATOR = ".";
    private Register register;
    private RegisterTree parent;
    private ArrayList<RegisterTree> children;
    private String name;

    public RegisterTree(Register reg) {
        this.name = reg.getName();
        this.register = reg;
        List<Register> registerChildren = reg.getChildRegisters();
        this.children = new ArrayList();
        for (Register childReg : registerChildren) {
            RegisterTree tree = new RegisterTree(childReg);
            tree.parent = this;
            this.children.add(tree);
        }
    }

    public RegisterTree(String name, Register[] regs) {
        this.name = name;
        this.children = new ArrayList();
        for (Register reg : regs) {
            if (!reg.isBaseRegister()) continue;
            RegisterTree tree = new RegisterTree(reg);
            tree.parent = this;
            this.children.add(tree);
        }
    }

    public RegisterTree(String name, RegisterTree tree) {
        this.name = name;
        this.children = new ArrayList();
        this.children.add(tree);
    }

    public String getName() {
        return this.name;
    }

    public void add(RegisterTree tree) {
        this.children.add(tree);
        tree.parent = this;
    }

    public RegisterTree[] getComponents() {
        return this.children.toArray(new RegisterTree[this.children.size()]);
    }

    public Register getRegister() {
        return this.register;
    }

    public RegisterTree getParent() {
        return this.parent;
    }

    public String getParentRegisterPath() {
        RegisterTree parentTree = this.getParent();
        if (parentTree == null || parentTree.getRegister() == null) {
            return null;
        }
        return parentTree.getRegisterPath();
    }

    public String getRegisterPath() {
        String parentPath = this.getParentRegisterPath();
        if (parentPath != null) {
            return parentPath + SEPARATOR + this.getRegister().getName();
        }
        return this.getRegister().getName();
    }

    public RegisterTree getRegisterTree(Register register1) {
        if (this.register == register1) {
            return this;
        }
        for (RegisterTree child : this.children) {
            RegisterTree tree = child.getRegisterTree(register1);
            if (tree == null) continue;
            return tree;
        }
        return null;
    }

    @Override
    public int compareTo(RegisterTree other) {
        return this.name.compareTo(other.name);
    }

    public void remove(Register reg) {
        RegisterTree tree = this.getRegisterTree(reg);
        if (tree == null) {
            return;
        }
        if (tree.getParent() == null) {
            return;
        }
        tree.getParent().children.remove(tree);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.name);
        buffer.append('[');
        for (RegisterTree child : this.children) {
            buffer.append(child.toString());
            buffer.append(',');
        }
        buffer.append(']');
        return buffer.toString();
    }
}

