/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import ghidra.framework.store.DataFileHandle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class LocalDataFileHandle
implements DataFileHandle {
    private RandomAccessFile raf;
    private boolean readOnly;

    public LocalDataFileHandle(File file, boolean readOnly) throws IOException {
        this.readOnly = readOnly;
        this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
    }

    @Override
    public void read(byte[] b) throws IOException {
        this.raf.readFully(b);
    }

    @Override
    public void read(byte[] b, int off, int len) throws IOException {
        this.raf.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    @Override
    public void write(int b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    @Override
    public long length() throws IOException {
        return this.raf.length();
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.raf.setLength(newLength);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.readOnly;
    }
}

