/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.address.SegmentedAddressSpace;

public class ProtectedAddressSpace
extends SegmentedAddressSpace {
    private static final int PROTECTEDMODE_SIZE = 32;
    private static final int PROTECTEDMODE_OFFSETSIZE = 16;
    private int offsetSize = 16;
    private long offsetMask = 1L;

    public ProtectedAddressSpace(String name, int unique) {
        super(name, 32, unique);
        this.offsetMask <<= this.offsetSize;
        --this.offsetMask;
        this.maxAddress = this.getUncheckedAddress(this.maxOffset);
    }

    @Override
    protected long getFlatOffset(int segment, long offset) {
        long res = segment;
        res <<= this.offsetSize;
        return res += offset;
    }

    @Override
    protected int getDefaultSegmentFromFlat(long flat) {
        return (int)(flat >>> this.offsetSize);
    }

    @Override
    protected long getDefaultOffsetFromFlat(long flat) {
        return flat & this.offsetMask;
    }

    @Override
    protected long getOffsetFromFlat(long flat, int segment) {
        return flat & this.offsetMask;
    }

    @Override
    protected SegmentedAddress getAddressInSegment(long flat, int preferredSegment) {
        return null;
    }

    @Override
    public int getNextOpenSegment(Address addr) {
        int res = this.getDefaultSegmentFromFlat(addr.getOffset());
        res = res + 8 & 0xFFF8;
        return res;
    }
}

