/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

public interface DataAdapterFromDataType
extends Data {
    default public String doToString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMnemonicString());
        String valueRepresentation = this.getDefaultValueRepresentation();
        if (valueRepresentation != null) {
            builder.append(' ');
            builder.append(valueRepresentation);
        }
        return builder.toString();
    }

    default public String getMnemonicString() {
        return this.getDataType().getMnemonic((Settings)this);
    }

    default public Address getAddress(int opIndex) {
        if (opIndex != 0) {
            return null;
        }
        Object obj = this.getValue();
        if (obj instanceof Address) {
            return (Address)obj;
        }
        return null;
    }

    default public Scalar getScalar(int opIndex) {
        if (opIndex != 0) {
            return null;
        }
        Object obj = this.getValue();
        if (obj instanceof Scalar) {
            return (Scalar)obj;
        }
        if (obj instanceof Address) {
            Address addrObj = (Address)obj;
            long offset = addrObj.getAddressableWordOffset();
            return new Scalar(addrObj.getAddressSpace().getPointerSize() * 8, offset, false);
        }
        return null;
    }

    default public Object getValue() {
        return this.getBaseDataType().getValue((MemBuffer)this, (Settings)this, this.getLength());
    }

    default public Class<?> getValueClass() {
        DataType base = this.getBaseDataType();
        if (base == null) {
            return null;
        }
        return base.getValueClass((Settings)this);
    }

    default public boolean hasStringValue() {
        Class<?> valueClass = this.getValueClass();
        if (valueClass == null) {
            return false;
        }
        return String.class.isAssignableFrom(valueClass);
    }

    default public boolean isPointer() {
        return this.getBaseDataType() instanceof Pointer;
    }

    default public boolean isUnion() {
        return this.getBaseDataType() instanceof Union;
    }

    default public boolean isStructure() {
        return this.getBaseDataType() instanceof Structure;
    }

    default public boolean isArray() {
        return this.getBaseDataType() instanceof Array;
    }

    default public boolean isDynamic() {
        return this.getBaseDataType() instanceof DynamicDataType;
    }

    default public String getDefaultValueRepresentation() {
        return this.getDataType().getRepresentation((MemBuffer)this, (Settings)this, this.getLength());
    }

    default public String getDefaultLabelPrefix(DataTypeDisplayOptions options) {
        return this.getDataType().getDefaultLabelPrefix((MemBuffer)this, (Settings)this, this.getLength(), options);
    }
}

