/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.trees;

import com.google.gson.JsonElement;
import generic.stl.Pair;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.trees.ExtModule;
import sarif.managers.ProgramTreeSarifMgr;

public class SarifTreeWriter
extends AbstractExtWriter {
    private List<Pair<String, ProgramModule>> modules;
    private List<Object> visited = new ArrayList<Object>();

    public SarifTreeWriter(List<Pair<String, ProgramModule>> target, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.modules = target;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genTree(monitor);
        this.root.add("trees", (JsonElement)this.objects);
    }

    private void genTree(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.modules.size());
        for (Pair<String, ProgramModule> pair : this.modules) {
            ExtModule isf = new ExtModule((String)pair.first, (ProgramModule)pair.second, this.visited);
            SarifObject sarif = new SarifObject(ProgramTreeSarifMgr.SUBKEY, ProgramTreeSarifMgr.KEY, this.getTree(isf), null);
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

