/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class NDS32Analyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "NDS32";
    private static final String RECOVER_GP_OPTION_NAME = "Recover global GP register writes";
    private static final String RECOVER_GP_OPTION_DESCRIPTION = "Reads the global GP value from the symbol _SDA_BASE_";
    private static final boolean RECOVER_GP_OPTION_DEFAULT_VALUE = true;
    private boolean recoverGp = true;
    private Address gpAssumptionValue = null;
    private Register gp;

    public NDS32Analyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.gp = program.getRegister("gp");
        return true;
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        options.registerOption(RECOVER_GP_OPTION_NAME, (Object)this.recoverGp, null, RECOVER_GP_OPTION_DESCRIPTION);
        this.recoverGp = options.getBoolean(RECOVER_GP_OPTION_NAME, this.recoverGp);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.gpAssumptionValue = null;
        this.checkForGlobalGP(program, set, monitor);
        return super.added(program, set, monitor, log);
    }

    private void checkForGlobalGP(Program program, AddressSetView set, TaskMonitor monitor) {
        if (!this.recoverGp) {
            return;
        }
        Symbol symbol = SymbolUtilities.getLabelOrFunctionSymbol((Program)program, (String)"_SDA_BASE_", err -> Msg.error((Object)((Object)this), (Object)err));
        if (symbol != null) {
            this.gpAssumptionValue = symbol.getAddress();
            return;
        }
    }

    public AddressSetView flowConstants(Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        Function func = program.getFunctionManager().getFunctionContaining(flowStart);
        AddressSet coveredSet = new AddressSet();
        Address currentGPAssumptionValue = this.gpAssumptionValue;
        if (func != null) {
            ProgramContext programContext;
            RegisterValue gpVal;
            flowStart = func.getEntryPoint();
            if (!(currentGPAssumptionValue == null || (gpVal = (programContext = program.getProgramContext()).getRegisterValue(this.gp, flowStart)) != null && gpVal.hasValue())) {
                gpVal = new RegisterValue(this.gp, BigInteger.valueOf(currentGPAssumptionValue.getOffset()));
                try {
                    program.getProgramContext().setRegisterValue(func.getEntryPoint(), func.getEntryPoint(), gpVal);
                }
                catch (ContextChangeException e) {
                    throw new AssertException("unexpected", (Throwable)e);
                }
            }
        }
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this, monitor, this.trustWriteMemOption){

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                FlowType flowtype = instruction.getFlowType();
                if (!flowtype.isJump()) {
                    return false;
                }
                return false;
            }
        };
        AddressSet resultSet = symEval.flowConstants(flowStart, null, (ContextEvaluator)eval, true, monitor);
        resultSet.add((AddressSetView)coveredSet);
        return resultSet;
    }
}

