/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.helpbrowser;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class HelpBrowserPanel
extends JPanel {
    private static final String TEST_HOME = "http://hem.bredband.net/catacombae/hfsx.html";
    private final URL homePage;
    private URL currentPage = null;
    private LinkedList<URL> history = new LinkedList();
    private JButton backButton;
    private JButton homeButton;
    private JTextPane htmlView;
    private JScrollPane htmlViewScroller;

    public HelpBrowserPanel(URL iHomePage) {
        this.homePage = iHomePage;
        this.initComponents();
        this.htmlView.setEditable(false);
        this.htmlView.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                URL url;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (url = e.getURL()) != null) {
                    HelpBrowserPanel.this.goToPage(url);
                }
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowserPanel.this.goBack();
            }
        });
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpBrowserPanel.this.goHome();
            }
        });
        this.goHome();
    }

    protected void goHome() {
        this.goToPage(this.homePage);
    }

    protected void goBack() {
        try {
            URL previousPage = this.history.getLast();
            this.htmlView.setPage(previousPage);
            this.currentPage = previousPage;
            this.history.removeLast();
        }
        catch (NoSuchElementException ex) {
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not load page " + this.currentPage, ex);
        }
    }

    protected void goToPage(URL iUrl) {
        try {
            if (this.currentPage != null && iUrl.equals(this.currentPage)) {
                this.htmlView.setPage(this.currentPage);
            } else {
                if (this.currentPage != null) {
                    this.history.addLast(this.currentPage);
                }
                this.htmlView.setPage(iUrl);
                this.currentPage = iUrl;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not load page " + iUrl, ex);
        }
    }

    public static void showHelpBrowserWindow(String iTitle, URL iHomePage) {
        JFrame f = new JFrame(iTitle);
        f.setDefaultCloseOperation(2);
        HelpBrowserPanel helpBrowserPanel = new HelpBrowserPanel(iHomePage);
        f.add(helpBrowserPanel);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private void initComponents() {
        this.backButton = new JButton();
        this.homeButton = new JButton();
        this.htmlViewScroller = new JScrollPane();
        this.htmlView = new JTextPane();
        this.backButton.setText("Back");
        this.homeButton.setText("Home");
        this.htmlViewScroller.setViewportView(this.htmlView);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.backButton).addPreferredGap(0).add((Component)this.homeButton).addContainerGap(486, Short.MAX_VALUE)).add((Component)this.htmlViewScroller, -1, 616, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.backButton).add((Component)this.homeButton)).addPreferredGap(0).add((Component)this.htmlViewScroller, -1, 330, Short.MAX_VALUE)));
    }
}

