/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.funcfixup;

import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.NameDeduper;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=1000)
public class ParamNameDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        String newName;
        NameDeduper nameDeduper = new NameDeduper();
        nameDeduper.addReservedNames(dfunc.getAllParamNames());
        nameDeduper.addReservedNames(dfunc.getAllLocalVariableNames());
        nameDeduper.addUsedNames(dfunc.getNonParamSymbolNames());
        for (DWARFVariable param : dfunc.params) {
            newName = nameDeduper.getUniqueName(param.name.getName());
            if (newName == null) continue;
            param.name = param.name.replaceName(newName, param.name.getOriginalName());
        }
        for (DWARFVariable localVar : dfunc.localVars) {
            newName = nameDeduper.getUniqueName(localVar.name.getName());
            if (newName == null) continue;
            localVar.name = localVar.name.replaceName(newName, localVar.name.getOriginalName());
        }
    }
}

