/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_ProtocolMethod
implements StructConverter {
    private static final String NAME = "objc_protocol_method";
    private ObjectiveC1_State _state;
    private ObjectiveC_MethodType _methodType;
    private String name;
    private String types;

    ObjectiveC1_ProtocolMethod(ObjectiveC1_State state, BinaryReader reader, ObjectiveC_MethodType methodType) throws IOException {
        this._state = state;
        this._methodType = methodType;
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.types = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
    }

    public String getName() {
        return this.name;
    }

    public String getTypes() {
        return this.types;
    }

    public ObjectiveC_MethodType getMethodType() {
        return this._methodType;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "types", null);
        return struct;
    }

    void applyTo() {
    }
}

