/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.xcoff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.xcoff.XCoffArchiveConstants;
import java.io.IOException;

public class XCoffArchiveHeader {
    private static final int _20 = 20;
    private byte[] fl_magic;
    private byte[] fl_memoff;
    private byte[] fl_gstoff;
    private byte[] fl_gst64off;
    private byte[] fl_fstmoff;
    private byte[] fl_lstmoff;
    private byte[] fl_freeoff;

    public XCoffArchiveHeader(ByteProvider provider) throws IOException {
        BinaryReader reader = new BinaryReader(provider, false);
        this.fl_magic = reader.readNextByteArray(XCoffArchiveConstants.MAGIC_LENGTH);
        this.fl_memoff = reader.readNextByteArray(20);
        this.fl_gstoff = reader.readNextByteArray(20);
        this.fl_gst64off = reader.readNextByteArray(20);
        this.fl_fstmoff = reader.readNextByteArray(20);
        this.fl_lstmoff = reader.readNextByteArray(20);
        this.fl_freeoff = reader.readNextByteArray(20);
    }

    public String fl_magic() {
        return new String(this.fl_magic).trim();
    }

    public long fl_memoff() {
        return Long.parseLong(new String(this.fl_memoff).trim());
    }

    public long fl_gstoff() {
        return Long.parseLong(new String(this.fl_gstoff).trim());
    }

    public long fl_gst64off() {
        return Long.parseLong(new String(this.fl_gst64off).trim());
    }

    public long fstmoff() {
        return Long.parseLong(new String(this.fl_fstmoff).trim());
    }

    public long lstmoff() {
        return Long.parseLong(new String(this.fl_lstmoff).trim());
    }

    public long fl_freeoff() {
        return Long.parseLong(new String(this.fl_freeoff).trim());
    }
}

