/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;

public class ClangFieldToken
extends ClangToken {
    private DataType datatype = null;
    private int offset;
    private PcodeOp op;

    public ClangFieldToken(ClangNode par) {
        super(par);
    }

    public DataType getDataType() {
        return this.datatype;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public PcodeOp getPcodeOp() {
        return this.op;
    }

    @Override
    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        String datatypestring = null;
        long id = 0L;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId == AttributeId.ATTRIB_NAME.id()) {
                datatypestring = decoder.readString();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_ID.id()) {
                id = decoder.readUnsignedInteger();
                continue;
            }
            if (attribId == AttributeId.ATTRIB_OFF.id()) {
                this.offset = (int)decoder.readSignedInteger();
                continue;
            }
            if (attribId != AttributeId.ATTRIB_OPREF.id()) continue;
            int refid = (int)decoder.readUnsignedInteger();
            this.op = pfactory.getOpRef(refid);
        }
        if (datatypestring != null) {
            this.datatype = pfactory.getDataTypeManager().findBaseType(datatypestring, id);
        }
        decoder.rewindAttributes();
        super.decode(decoder, pfactory);
    }
}

