/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.features.codecompare.graphanalysis.CtrlVertex;
import ghidra.features.codecompare.graphanalysis.Pinning;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlockBasic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CtrlGraph {
    Pinning.Side side;
    HighFunction hfunc;
    Map<PcodeBlockBasic, CtrlVertex> blockToVertex;
    ArrayList<CtrlVertex> nodeList;

    public CtrlGraph(Pinning.Side side, HighFunction hfunct) {
        this.side = side;
        this.hfunc = hfunct;
        this.nodeList = new ArrayList();
        this.blockToVertex = new HashMap<PcodeBlockBasic, CtrlVertex>();
        ArrayList blockList = this.hfunc.getBasicBlocks();
        int uidCounter = 0;
        for (PcodeBlockBasic curBlock : blockList) {
            CtrlVertex temp = new CtrlVertex(curBlock, uidCounter++, this);
            this.blockToVertex.put(curBlock, temp);
            this.nodeList.add(temp);
        }
        for (PcodeBlockBasic curBlock : blockList) {
            CtrlVertex curVert = this.blockToVertex.get(curBlock);
            for (int i = 0; i < curBlock.getOutSize(); ++i) {
                PcodeBlockBasic neighborBlock = (PcodeBlockBasic)curBlock.getOut(i);
                CtrlVertex neighborVert = this.blockToVertex.get(neighborBlock);
                neighborVert.sources.add(curVert);
                curVert.sinks.add(neighborVert);
            }
        }
    }

    public void clearNGrams() {
        for (CtrlVertex node : this.nodeList) {
            node.clearNGrams();
        }
    }

    public void addEdgeColor() {
        for (CtrlVertex vert : this.nodeList) {
            vert.addEdgeColor();
        }
    }

    public void makeNGrams(int numNGrams) {
        int sourceSize = (numNGrams - 1) / 2 + 1;
        for (int i = 0; i < sourceSize; ++i) {
            for (CtrlVertex node : this.nodeList) {
                node.nextNGramSource(i);
            }
        }
        for (CtrlVertex node : this.nodeList) {
            node.nextNGramSink(0);
        }
        for (int i = sourceSize + 1; i < numNGrams - 1; ++i) {
            for (CtrlVertex node : this.nodeList) {
                node.nextNGramSink(i);
            }
        }
    }
}

