/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.RadialTreeLayout;
import org.jungrapht.visualization.layout.algorithms.TreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.PolarPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialTreeLayoutAlgorithm<V>
extends TreeLayoutAlgorithm<V>
implements RadialTreeLayout<V> {
    private static final Logger log = LoggerFactory.getLogger(RadialTreeLayoutAlgorithm.class);
    protected Map<V, PolarPoint> polarLocations = new HashMap<V, PolarPoint>();

    public static <V> Builder<V, ?, ?> builder() {
        return (Builder)new Builder().expandLayout(false);
    }

    public RadialTreeLayoutAlgorithm() {
        this(RadialTreeLayoutAlgorithm.builder());
    }

    protected RadialTreeLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
    }

    @Override
    protected Set<V> buildTree(LayoutModel<V> layoutModel) {
        Set<V> roots = super.buildTree(layoutModel);
        this.setRadialLocations(roots, layoutModel);
        this.putRadialPointsInModel(layoutModel);
        int diameter = this.diameter(layoutModel);
        int offsetDelta = diameter - layoutModel.getWidth();
        this.offset(layoutModel, offsetDelta / 2);
        layoutModel.setSize(diameter, diameter);
        return roots;
    }

    protected void offset(LayoutModel<V> layoutModel, int delta) {
        layoutModel.getGraph().vertexSet().forEach(v -> {
            Point p = layoutModel.get(v);
            p = p.add(delta, delta);
            layoutModel.set(v, p);
        });
    }

    @Override
    public int diameter(LayoutModel<V> layoutModel) {
        return layoutModel.getGraph().vertexSet().stream().map(vertex -> this.polarLocations.get((Object)vertex).radius * 2.0).mapToInt(Double::intValue).max().orElse(layoutModel.getWidth()) + this.horizontalVertexSpacing;
    }

    @Override
    protected int getInitialPosition(int initialPosition, int layoutHeight, int treeHeight) {
        return 0;
    }

    protected void putRadialPointsInModel(LayoutModel<V> layoutModel) {
        this.polarLocations.forEach((key, value) -> layoutModel.set(key, this.getCartesian(layoutModel, key)));
    }

    @Override
    public Map<V, PolarPoint> getPolarLocations() {
        return this.polarLocations;
    }

    protected Point getCartesian(LayoutModel<V> layoutModel, V vertex) {
        PolarPoint pp = this.polarLocations.get(vertex);
        double centerX = layoutModel.getWidth() / 2;
        double centerY = layoutModel.getHeight() / 2;
        Point cartesian = PolarPoint.polarToCartesian(pp);
        cartesian = cartesian.add(centerX, centerY);
        return cartesian;
    }

    protected Point getMaxXY(LayoutModel<V> layoutModel) {
        double maxx = 0.0;
        double maxy = 0.0;
        Set vertices = layoutModel.getGraph().vertexSet();
        for (Object vertex : vertices) {
            Point location = (Point)layoutModel.apply(vertex);
            maxx = Math.max(maxx, location.x);
            maxy = Math.max(maxy, location.y);
        }
        return Point.of(maxx, maxy);
    }

    protected void setRadialLocations(Set<V> roots, LayoutModel<V> layoutModel) {
        int width = layoutModel.getWidth();
        Point max = this.getMaxXY(layoutModel);
        double maxx = max.x + (double)this.verticalVertexSpacing;
        maxx = Math.max(maxx, (double)width);
        double theta = Math.PI * 2 / maxx;
        double deltaRadius = 1.0;
        double offset = 0.0;
        if (roots.size() > 1) {
            offset = this.verticalVertexSpacing;
        }
        for (Object vertex : layoutModel.getGraph().vertexSet()) {
            Point p = layoutModel.get(vertex);
            PolarPoint polarPoint = PolarPoint.of(p.x * theta, (offset + p.y - (double)this.verticalVertexSpacing) * deltaRadius);
            this.polarLocations.put((PolarPoint)vertex, polarPoint);
        }
    }

    @Override
    public boolean constrained() {
        return true;
    }

    public static class Builder<V, T extends RadialTreeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends TreeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new RadialTreeLayoutAlgorithm(this);
        }
    }
}

