/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyCycleRemoval<V, E> {
    private static final Logger log = LoggerFactory.getLogger(GreedyCycleRemoval.class);
    final Collection<E> feedbackArcs = new HashSet();
    final Graph<V, E> graph;
    final Graph<V, E> copy;

    public GreedyCycleRemoval(Graph<V, E> graph) {
        this.graph = graph;
        this.copy = GraphTypeBuilder.forGraph(graph).buildGraph();
        Graphs.addGraph(this.copy, graph);
        this.getFeedbackEdges();
    }

    public Collection<E> getFeedbackArcs() {
        return this.feedbackArcs;
    }

    private Optional<V> getSink(Graph<V, E> graph) {
        return graph.vertexSet().stream().filter(v -> graph.outgoingEdgesOf(v).isEmpty()).findFirst();
    }

    private Optional<V> getSource(Graph<V, E> graph) {
        return graph.vertexSet().stream().filter(v -> graph.incomingEdgesOf(v).isEmpty()).findFirst();
    }

    private Collection<V> getIsolatedVertices(Graph<V, E> graph) {
        return graph.vertexSet().stream().filter(v -> graph.degreeOf(v) == 0 || GreedyCycleRemoval.isLoopVertex(graph, v)).collect(Collectors.toList());
    }

    public static <V, E> boolean isLoopVertex(Graph<V, E> graph, V v) {
        return graph.outgoingEdgesOf(v).equals(graph.incomingEdgesOf(v));
    }

    public static <V, E> boolean isIsolatedVertex(Graph<V, E> graph, V v) {
        return graph.degreeOf(v) == 0;
    }

    private void getFeedbackEdges() {
        Collection losers;
        Optional<V> opt;
        while ((opt = this.getSink(this.copy)).isPresent()) {
            V sink = opt.get();
            losers = this.copy.edgeSet().stream().filter(e -> this.copy.getEdgeTarget(e).equals(sink)).collect(Collectors.toList());
            if (log.isTraceEnabled()) {
                log.trace("removing sink {} and incoming edges {}", sink, (Object)losers);
            }
            this.copy.removeAllEdges(losers);
            this.copy.removeVertex(sink);
        }
        this.copy.removeAllVertices(this.getIsolatedVertices(this.copy));
        while ((opt = this.getSource(this.copy)).isPresent()) {
            V source = opt.get();
            losers = this.copy.edgeSet().stream().filter(e -> this.copy.getEdgeTarget(e).equals(source)).collect(Collectors.toList());
            if (log.isTraceEnabled()) {
                log.trace("removing source {} and incoming edges {}", source, (Object)losers);
            }
            this.copy.removeAllEdges(losers);
            this.copy.removeVertex(source);
        }
        ArrayList orderedBy = new ArrayList(this.copy.vertexSet());
        orderedBy.sort((l, r) -> {
            int leftDiff = this.copy.outDegreeOf(l) - this.copy.inDegreeOf(l);
            int rightDiff = this.copy.outDegreeOf(r) - this.copy.inDegreeOf(r);
            return -Integer.compare(leftDiff, rightDiff);
        });
        for (Object v : orderedBy) {
            LinkedHashSet outgoingEdges = new LinkedHashSet(this.copy.outgoingEdgesOf(v));
            LinkedHashSet incomingEdges = new LinkedHashSet(this.copy.incomingEdgesOf(v));
            if (log.isTraceEnabled()) {
                log.trace("incoming {} going to feedbackArcs", incomingEdges);
            }
            this.feedbackArcs.addAll(incomingEdges);
            this.copy.removeAllEdges(outgoingEdges);
            this.copy.removeAllEdges(incomingEdges);
            this.copy.removeVertex(v);
        }
        if (log.isTraceEnabled()) {
            log.trace("copy graph is {}", this.copy);
            log.trace("feedbackArcs {}", this.feedbackArcs);
        }
    }

    public void reverseFeedbackArcs() {
        for (E edge : this.feedbackArcs) {
            Object source = this.graph.getEdgeSource(edge);
            Object target = this.graph.getEdgeTarget(edge);
            this.graph.removeEdge(edge);
            this.graph.addEdge(target, source, edge);
        }
    }
}

