/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.ToolTipUtils;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import org.apache.commons.lang3.StringUtils;

public class BitFieldDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    public BitFieldDataTypeHTMLRepresentation(BitFieldDataType bitFieldDt) {
        super(BitFieldDataTypeHTMLRepresentation.buildHTMLText(bitFieldDt));
    }

    private static String buildHTMLText(BitFieldDataType bitFieldDt) {
        String description;
        StringBuilder buffer = new StringBuilder();
        DataType baseDataType = bitFieldDt.getBaseDataType();
        HTMLDataTypeRepresentation representation = ToolTipUtils.getHTMLRepresentation(baseDataType);
        String baseHTML = representation.getHTMLContentString();
        buffer.append(baseHTML);
        if (baseHTML.indexOf("Length: ") < 0) {
            String lengthString = BitFieldDataTypeHTMLRepresentation.getDataTypeLengthString((DataType)bitFieldDt);
            buffer.append("Length: ").append(lengthString);
        }
        if (StringUtils.isBlank((CharSequence)(description = bitFieldDt.getDescription()))) {
            description = bitFieldDt.getDisplayName();
        }
        description = HTMLUtilities.friendlyEncodeHTML((String)description);
        buffer.append(description);
        buffer.append("<BR>").append("<BR>");
        buffer.append("Bitfield Base Data Type: ").append("<BR>");
        buffer.append("<DIV STYLE='margin-left: 10px;'>");
        buffer.append(baseHTML);
        buffer.append("</DIV>");
        return buffer.toString();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        throw new AssertException("Bitfield types are not diffable at this time");
    }
}

