/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;

public abstract class AbstractOneMethodMsType
extends AbstractMsType
implements MsTypeField {
    protected ClassFieldMsAttributes attributes;
    protected RecordNumber procedureTypeRecordNumber;
    protected long offsetInVFTableIfIntroVirtual;
    protected String name;

    public AbstractOneMethodMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.attributes = new ClassFieldMsAttributes(reader);
        this.procedureTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.offsetInVFTableIfIntroVirtual = this.attributes.getProperty() == ClassFieldMsAttributes.Property.INTRO || this.attributes.getProperty() == ClassFieldMsAttributes.Property.INTRO_PURE ? reader.parseUnsignedIntVal() : -1L;
        this.name = reader.parseString(pdb, strType);
        reader.skipPadding();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RecordNumber getProcedureTypeRecordNumber() {
        return this.procedureTypeRecordNumber;
    }

    public ClassFieldMsAttributes getAttributes() {
        return this.attributes;
    }

    public long getOffsetInVFTableIfIntroVirtual() {
        return this.offsetInVFTableIfIntroVirtual;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append("<");
        builder.append(this.attributes);
        builder.append(": ");
        builder.append(this.pdb.getTypeRecord(this.procedureTypeRecordNumber));
        if (this.offsetInVFTableIfIntroVirtual != -1L) {
            builder.append(",");
            builder.append(this.offsetInVFTableIfIntroVirtual);
        }
        builder.append(">");
    }
}

