/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.pcode.utils.Utils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.memory.TraceRegister;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import java.math.BigInteger;

public class DBTraceObjectRegister
implements TraceRegister,
DBTraceObjectInterface {
    private final DBTraceObject object;

    public DBTraceObjectRegister(DBTraceObject object) {
        this.object = object;
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceThread getThread() {
        return this.object.queryCanonicalAncestorsInterface(TraceThread.class).findAny().orElseThrow();
    }

    @Override
    public String getName() {
        KeyPath path = this.object.getCanonicalPath();
        return KeyPath.parseIfIndex(path.key());
    }

    @Override
    public int getBitLength(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_length", Integer.class, 0);
    }

    @Override
    public void setValue(Lifespan lifespan, byte[] value) {
        int length = this.getByteLength(lifespan.lmin());
        if (length != 0 && value.length != length) {
            throw new IllegalArgumentException("Length must match the register");
        }
        this.object.setValue(lifespan, "_value", value);
    }

    @Override
    public byte[] getValue(long snap) {
        DBTraceObjectValue ov = this.object.getValue(snap, "_value");
        if (ov == null) {
            return null;
        }
        Object val = ov.getValue();
        if (val instanceof byte[]) {
            byte[] arr = (byte[])val;
            return arr;
        }
        if (val instanceof String) {
            String str = (String)val;
            BigInteger bigVal = new BigInteger(str, 16);
            return Utils.bigIntegerToBytes((BigInteger)bigVal, (int)this.getByteLength(snap), (boolean)true);
        }
        throw new ClassCastException("Cannot convert " + String.valueOf(val) + " to byte array for register value");
    }

    @Override
    public void setState(Lifespan lifespan, TraceMemoryState state) {
        this.object.setValue(lifespan, "_state", state.ordinal());
    }

    @Override
    public TraceMemoryState getState(long snap) {
        return TraceMemoryState.values()[TraceObjectInterfaceUtils.getValue(this.object, snap, "_state", Integer.class, TraceMemoryState.UNKNOWN.ordinal())];
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return null;
    }
}

