/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.decorators;

import java.awt.Color;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.util.function.Function;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;

public class GradientVertexPaintFunction<V, E>
implements Function<V, Paint> {
    protected VisualizationServer<V, E> visualizationServer;
    protected Function<V, Paint> originalVertexPaintFunction;

    public GradientVertexPaintFunction(VisualizationServer<V, E> visualizationServer) {
        this.visualizationServer = visualizationServer;
        this.originalVertexPaintFunction = visualizationServer.getRenderContext().getVertexFillPaintFunction();
    }

    @Override
    public Paint apply(V vertex) {
        LayoutModel<V> layoutModel = this.visualizationServer.getVisualizationModel().getLayoutModel();
        MultiLayerTransformer transformer = this.visualizationServer.getRenderContext().getMultiLayerTransformer();
        float radius = (float)this.visualizationServer.getRenderContext().getVertexBoundsFunction().apply(vertex).width / 2.0f;
        Point layoutPoint = (Point)layoutModel.apply(vertex);
        Point2D vertexInView = transformer.transform(MultiLayerTransformer.Layer.LAYOUT, layoutPoint.x, layoutPoint.y);
        Color vertexColor = (Color)this.originalVertexPaintFunction.apply(vertex);
        Color vertexColor2 = Color.white;
        return new RadialGradientPaint(vertexInView, radius, new float[]{0.0f, 1.0f}, new Color[]{vertexColor2, vertexColor});
    }
}

