/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashBasicDirectoryInode;
import ghidra.file.formats.squashfs.SquashDirectoryTableEntry;
import ghidra.file.formats.squashfs.SquashDirectoryTableHeader;
import ghidra.file.formats.squashfs.SquashFragmentTable;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashInodeTable;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import ghidra.file.formats.squashfs.SquashUtils;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SquashDirectoryTable {
    private final Map<Long, SquashDirectoryTableHeader> headersByOffset;
    private final Map<Long, Long> archiveToReaderOffsets;

    public SquashDirectoryTable(BinaryReader reader, SquashSuperBlock superBlock, SquashFragmentTable fragTable, TaskMonitor monitor) throws IOException, CancelledException {
        reader.setPointerIndex(superBlock.getDirectoryTableStart());
        long endOfDirTable = !superBlock.isFragmentsUnused() && superBlock.getTotalFragments() > 0L ? fragTable.getMinFragPointer() : superBlock.getFragmentTableStart();
        this.headersByOffset = new HashMap<Long, SquashDirectoryTableHeader>();
        this.archiveToReaderOffsets = new HashMap<Long, Long>();
        reader = this.decompressDirectoryTable(reader, endOfDirTable, superBlock.getCompressionType(), monitor);
        while (reader.hasNext()) {
            monitor.checkCancelled();
            this.headersByOffset.put(reader.getPointerIndex(), new SquashDirectoryTableHeader(reader, superBlock, monitor));
        }
    }

    public void assignInodes(SquashInodeTable inodeTable, TaskMonitor monitor) throws CancelledException {
        for (long offset : this.headersByOffset.keySet()) {
            monitor.checkCancelled();
            SquashDirectoryTableHeader header = this.headersByOffset.get(offset);
            for (SquashDirectoryTableEntry child : header.getEntries()) {
                SquashInode inode = inodeTable.getInodeByNumber(child.getInodeNumber());
                inode.setDirectoryTableEntry(child);
            }
        }
    }

    public List<SquashDirectoryTableHeader> getHeaders(SquashBasicDirectoryInode inode) {
        ArrayList<SquashDirectoryTableHeader> headers = new ArrayList<SquashDirectoryTableHeader>();
        long blockStart = this.archiveToReaderOffsets.get(inode.getIndex());
        long start = blockStart + (long)inode.getOffset();
        long end = start + inode.getUncompressedSize() - 3L;
        for (long offset : this.headersByOffset.keySet()) {
            if (offset < start || offset >= end) continue;
            headers.add(this.headersByOffset.get(offset));
        }
        return headers;
    }

    private BinaryReader decompressDirectoryTable(BinaryReader reader, long endAddress, int compressionType, TaskMonitor monitor) throws IOException, CancelledException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int totalUncompressedBytes = 0;
        long directoryTableStart = reader.getPointerIndex();
        while (reader.getPointerIndex() < endAddress) {
            monitor.checkCancelled();
            long startOfBlockOffset = reader.getPointerIndex() - directoryTableStart;
            byte[] bytes = SquashUtils.decompressBlock(reader, compressionType, monitor);
            bos.write(bytes);
            this.archiveToReaderOffsets.put(startOfBlockOffset, Long.valueOf(totalUncompressedBytes));
            totalUncompressedBytes += bytes.length;
        }
        return SquashUtils.byteArrayToReader(bos.toByteArray());
    }
}

