/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMethodRecordMs;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMethodListMsType
extends AbstractMsType {
    protected List<AbstractMethodRecordMs> methodRecords = new ArrayList<AbstractMethodRecordMs>();

    public AbstractMethodListMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        while (reader.hasMore()) {
            AbstractMethodRecordMs record = this.parseOneRecord(pdb, reader);
            this.methodRecords.add(record);
        }
    }

    public int getListSize() {
        return this.methodRecords.size();
    }

    public List<AbstractMethodRecordMs> getList() {
        return this.methodRecords;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        DelimiterState ds = new DelimiterState("", ",");
        builder.append("{");
        for (AbstractMethodRecordMs record : this.methodRecords) {
            builder.append(ds.out(true, record.toString()));
        }
        builder.append("}");
    }

    protected abstract AbstractMethodRecordMs parseOneRecord(AbstractPdb var1, PdbByteReader var2) throws PdbException;
}

