/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractPointerMsType
extends AbstractMsType {
    protected RecordNumber underlyingRecordNumber;
    protected PointerType pointerType;
    protected MsPointerMode pointerMode;
    protected boolean isFlat;
    protected boolean isVolatile;
    protected boolean isConst;
    protected boolean isUnaligned;
    protected RecordNumber memberPointerContainingClassRecordNumber;
    protected MemberPointerType memberPointerType;
    protected int baseSegment;
    protected String baseSymbol;
    protected RecordNumber pointerBaseTypeRecordNumber;
    protected String name;

    public AbstractPointerMsType(AbstractPdb pdb, PdbByteReader reader) {
        super(pdb, reader);
    }

    public void parseExtendedPointerInfo(PdbByteReader reader, int intSize, StringParseType stringType) throws PdbException {
        if (this.pointerMode == MsPointerMode.MEMBER_DATA_POINTER || this.pointerMode == MsPointerMode.MEMBER_FUNCTION_POINTER) {
            this.memberPointerContainingClassRecordNumber = RecordNumber.parse(this.pdb, reader, RecordCategory.TYPE, intSize);
            this.memberPointerType = MemberPointerType.fromValue(reader.parseUnsignedShortVal());
            if (reader.hasMore()) {
                reader.parseBytesRemaining();
            }
        } else if (this.pointerType == PointerType.SEGMENT_BASED) {
            this.baseSegment = this.pdb.parseSegment(reader);
            if (reader.hasMore()) {
                reader.parseBytesRemaining();
            }
        } else if (this.pointerType == PointerType.TYPE_BASED) {
            this.pointerBaseTypeRecordNumber = RecordNumber.parse(this.pdb, reader, RecordCategory.TYPE, intSize);
            this.name = reader.parseString(this.pdb, stringType);
            reader.skipPadding();
            if (reader.hasMore()) {
                reader.parseBytesRemaining();
            }
        } else if (this.pointerType == PointerType.INVALID) {
            this.baseSymbol = reader.parseString(this.pdb, stringType);
            reader.skipPadding();
        } else if (reader.hasMore()) {
            PdbLog.message("Unexpected data in " + this.getClass().getSimpleName() + ":\n" + reader.dump());
        }
        reader.skipPadding();
    }

    public AbstractMsType getUnderlyingType() {
        return this.pdb.getTypeRecord(this.underlyingRecordNumber);
    }

    public RecordNumber getUnderlyingRecordNumber() {
        return this.underlyingRecordNumber;
    }

    @Override
    public BigInteger getSize() {
        return BigInteger.valueOf(this.getMySize());
    }

    public PointerType getPointerType() {
        return this.pointerType;
    }

    public MsPointerMode getPointerMode() {
        return this.pointerMode;
    }

    public MemberPointerType getMemberPointerType() {
        return this.memberPointerType;
    }

    public boolean isFlat() {
        return this.isFlat;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public RecordNumber getMemberPointerContainingClassRecordNumber() {
        return this.memberPointerContainingClassRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.isFlat ? "flat " : "");
        switch (this.pointerMode.ordinal()) {
            case 3: 
            case 4: {
                this.pdb.getTypeRecord(this.memberPointerContainingClassRecordNumber).emit(builder, AbstractMsType.Bind.NONE);
                myBuilder.append((Object)this.pointerMode);
                myBuilder.append(" <");
                myBuilder.append((Object)this.memberPointerType);
                myBuilder.append(">");
                break;
            }
            default: {
                myBuilder.append((Object)this.pointerType);
                myBuilder.append((Object)this.pointerMode);
            }
        }
        myBuilder.append(this.isConst ? "const " : "");
        myBuilder.append(this.isVolatile ? "volatile " : "");
        myBuilder.append(" ");
        builder.insert(0, myBuilder);
        builder.append(" ");
        this.getUnderlyingType().emit(builder, AbstractMsType.Bind.PTR);
    }

    protected abstract void parseAttributes(PdbByteReader var1) throws PdbException;

    protected abstract int getMySize();

    public static enum MsPointerMode {
        INVALID("", -1),
        POINTER("*", 0),
        LVALUE_REFERENCE("&", 1),
        MEMBER_DATA_POINTER("::*", 2),
        MEMBER_FUNCTION_POINTER("::*", 3),
        RVALUE_REFERENCE("&&", 4),
        RESERVED("", 5);

        private static final Map<Integer, MsPointerMode> BY_VALUE;
        public final String label;
        public final int value;

        public void emit(StringBuilder builder) {
            builder.append(((Object)((Object)this)).getClass().getSimpleName());
        }

        public String toString() {
            return this.label;
        }

        public static MsPointerMode fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private MsPointerMode(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, MsPointerMode>();
            for (MsPointerMode val : MsPointerMode.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    public static enum MemberPointerType {
        INVALID("invalid", -1),
        UNSPECIFIED("pdm16_nonvirt", 0),
        DATA_SINGLE_INHERITANCE("pdm16_vfcn", 1),
        DATA_MULTIPLE_INHERITANCE("pdm16_vbase", 2),
        DATA_VIRTUAL_INHERITANCE("pdm32_nvvfcn", 3),
        DATA_GENERAL("pdm32_vbase", 4),
        FUNCTION_SINGLE_INHERITANCE("pmf16_nearnvsa", 5),
        FUNCTION_MULTIPLE_INHERITANCE("pmf16_nearnvma", 6),
        FUNCTION_VIRTUAL_INHERITANCE("pmf16_nearvbase", 7),
        FUNCTION_SINGLE_INHERITANCE_1632("pmf16_farnvsa", 8),
        FUNCTION_MULTIPLE_INHERITANCE_1632("pmf16_farnvma", 9),
        FUNCTION_VIRTUAL_INHERITANCE_1632("pmf16_farvbase", 10),
        FUNCTION_SINGLE_INHERITANCE_32("pmf32_nvsa", 11),
        FUNCTION_MULTIPLE_INHERITANCE_32("pmf32_nvma", 12),
        FUNCTION_VIRTUAL_INHERITANCE_32("pmf32_vbase", 13);

        private static final Map<Integer, MemberPointerType> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static MemberPointerType fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private MemberPointerType(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, MemberPointerType>();
            for (MemberPointerType val : MemberPointerType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }

    public static enum PointerType {
        INVALID("invalid", -1),
        NEAR("near", 0),
        FAR("far", 1),
        HUGE("huge", 2),
        SEGMENT_BASED("base(seg)", 3),
        VALUE_BASED("base(val)", 4),
        SEGMENT_VALUE_BASED("base(segval)", 5),
        ADDRESS_BASED("base(addr)", 6),
        SEGMENT_ADDRESS_BASED("base(segaddr)", 7),
        TYPE_BASED("base(type)", 8),
        SELF_BASED("base(addr)", 9),
        NEAR32("", 10),
        FAR32("far32", 11),
        PTR64("far64", 12),
        UNSPECIFIED("unspecified", 13);

        private static final Map<Integer, PointerType> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static PointerType fromValue(int val) {
            return BY_VALUE.getOrDefault(val, INVALID);
        }

        private PointerType(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, PointerType>();
            for (PointerType val : PointerType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

