/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import ghidra.async.SwingExecutorService;
import java.lang.ref.Cleaner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface AsyncUtils {
    public static final Cleaner CLEANER = Cleaner.create();
    public static final ExecutorService FRAMEWORK_EXECUTOR = Executors.newWorkStealingPool();
    public static final ExecutorService SWING_EXECUTOR = SwingExecutorService.LATER;

    public static <T> CompletableFuture<T> nil() {
        return CompletableFuture.completedFuture(null);
    }

    public static Throwable unwrapThrowable(Throwable e) {
        Throwable exc = e;
        while (exc instanceof CompletionException || exc instanceof ExecutionException) {
            exc = exc.getCause();
        }
        return exc;
    }

    public static <T> BiFunction<T, Throwable, T> copyTo(CompletableFuture<T> dest) {
        return (t, ex) -> {
            if (ex != null) {
                dest.completeExceptionally((Throwable)ex);
                return ExceptionUtils.rethrow((Throwable)ex);
            }
            dest.complete(t);
            return t;
        };
    }

    public static interface TemperamentalSupplier<T> {
        public T get() throws Throwable;
    }

    public static interface TemperamentalRunnable {
        public void run() throws Throwable;
    }
}

