/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import org.jungrapht.visualization.DefaultVisualizationViewer;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContextStateChange;
import org.jungrapht.visualization.SatelliteVisualizationViewer;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.transform.MutableAffineTransformer;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;

public class DefaultSatelliteVisualizationViewer<V, E>
extends DefaultVisualizationViewer<V, E>
implements SatelliteVisualizationViewer<V, E> {
    VisualizationViewer<V, E> master;
    boolean transparent;
    Color lensColor;

    DefaultSatelliteVisualizationViewer(SatelliteVisualizationViewer.Builder<V, E, ?, ?> builder) {
        super(builder);
        this.master = builder.master;
        this.transparent = builder.transparent;
        this.lensColor = builder.lensColor;
        this.setGraphMouse(builder.graphMouse);
        this.setOpaque(!this.transparent);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.addPreRenderPaintable(new SatelliteVisualizationViewer.ViewLens<V, E>(this, this.master));
        AffineTransform modelLayoutTransform = new AffineTransform(this.master.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform());
        this.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, new MutableAffineTransformer(modelLayoutTransform));
        this.setVisualizationModel(this.master.getVisualizationModel());
        this.master.addChangeListener(this);
        this.master.getVisualizationModel().getModelChangeSupport().addModelChangeListener(this::scaleToLayout);
        this.setSelectedVertexState(this.master.getSelectedVertexState());
        this.setSelectedEdgeState(this.master.getSelectedEdgeState());
        this.setVertexSpatial((Spatial)new Spatial.NoOp.Vertex(this.visualizationModel.getLayoutModel()));
        this.setEdgeSpatial((Spatial)new Spatial.NoOp.Edge(this.visualizationModel));
        this.getRenderContext().setVertexShapeFunction(this.master.getRenderContext().getVertexShapeFunction());
        this.getRenderContext().setEdgeShapeFunction(this.master.getRenderContext().getEdgeShapeFunction());
    }

    @Override
    public void renderContextStateChanged(RenderContextStateChange.Event evt) {
    }

    @Override
    protected void renderGraph(Graphics2D g2d) {
        this.getRenderContext().setVertexShapeFunction(this.master.getRenderContext().getVertexShapeFunction());
        this.getRenderContext().setEdgeShapeFunction(this.master.getRenderContext().getEdgeShapeFunction());
        if (this.renderContext.getGraphicsContext() == null) {
            this.renderContext.setGraphicsContext(new GraphicsDecorator(g2d));
        } else {
            this.renderContext.getGraphicsContext().setDelegate(g2d);
        }
        this.renderContext.setScreenDevice(this);
        g2d.setRenderingHints(this.renderingHints);
        Dimension d = this.getSize();
        if (!this.transparent) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, d.width, d.height);
        }
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        for (VisualizationServer.Paintable paintable : this.preRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        this.renderer.render(this.renderContext, this.visualizationModel.getLayoutModel());
        for (VisualizationServer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    @Override
    public VisualizationViewer<V, E> getMaster() {
        return this.master;
    }

    @Override
    public Color getLensColor() {
        return this.lensColor;
    }
}

