/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.type;

import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.type.DoubleReadGen;
import ghidra.pcode.emu.jit.gen.type.DoubleWriteGen;
import ghidra.pcode.emu.jit.gen.type.FloatReadGen;
import ghidra.pcode.emu.jit.gen.type.FloatWriteGen;
import ghidra.pcode.emu.jit.gen.type.IntReadGen;
import ghidra.pcode.emu.jit.gen.type.IntWriteGen;
import ghidra.pcode.emu.jit.gen.type.LongReadGen;
import ghidra.pcode.emu.jit.gen.type.LongWriteGen;
import ghidra.pcode.emu.jit.gen.type.MpIntReadGen;
import ghidra.pcode.emu.jit.gen.type.MpIntWriteGen;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.pcode.Varnode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.MethodVisitor;

public interface TypedAccessGen {
    public static TypedAccessGen lookupReader(Endian endian, JitType type) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> {
                JitType v0 = type;
                Objects.requireNonNull(v0);
                JitType var2_2 = v0;
                int var3_4 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)var2_2, var3_4)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)var2_2;
                        yield IntReadGen.BE;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)var2_2;
                        yield LongReadGen.BE;
                    }
                    case 2: {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_2;
                        yield FloatReadGen.BE;
                    }
                    case 3: {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_2;
                        yield DoubleReadGen.BE;
                    }
                    case 4: {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_2;
                        yield MpIntReadGen.BE;
                    }
                }
                throw new AssertionError();
            }
            case Endian.LITTLE -> {
                JitType v2 = type;
                Objects.requireNonNull(v2);
                JitType var2_3 = v2;
                int var3_5 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)var2_3, var3_5)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)var2_3;
                        yield IntReadGen.LE;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)var2_3;
                        yield LongReadGen.LE;
                    }
                    case 2: {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_3;
                        yield FloatReadGen.LE;
                    }
                    case 3: {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_3;
                        yield DoubleReadGen.LE;
                    }
                    case 4: {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_3;
                        yield MpIntReadGen.LE;
                    }
                }
                throw new AssertionError();
            }
        };
    }

    public static TypedAccessGen lookupWriter(Endian endian, JitType type) {
        return switch (endian) {
            default -> throw new MatchException(null, null);
            case Endian.BIG -> {
                JitType v0 = type;
                Objects.requireNonNull(v0);
                JitType var2_2 = v0;
                int var3_4 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)var2_2, var3_4)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)var2_2;
                        yield IntWriteGen.BE;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)var2_2;
                        yield LongWriteGen.BE;
                    }
                    case 2: {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_2;
                        yield FloatWriteGen.BE;
                    }
                    case 3: {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_2;
                        yield DoubleWriteGen.BE;
                    }
                    case 4: {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_2;
                        yield MpIntWriteGen.BE;
                    }
                }
                throw new AssertionError();
            }
            case Endian.LITTLE -> {
                JitType v2 = type;
                Objects.requireNonNull(v2);
                JitType var2_3 = v2;
                int var3_5 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.IntJitType.class, JitType.LongJitType.class, JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpIntJitType.class}, (Object)var2_3, var3_5)) {
                    case 0: {
                        JitType.IntJitType t = (JitType.IntJitType)var2_3;
                        yield IntWriteGen.LE;
                    }
                    case 1: {
                        JitType.LongJitType t = (JitType.LongJitType)var2_3;
                        yield LongWriteGen.LE;
                    }
                    case 2: {
                        JitType.FloatJitType t = (JitType.FloatJitType)var2_3;
                        yield FloatWriteGen.LE;
                    }
                    case 3: {
                        JitType.DoubleJitType t = (JitType.DoubleJitType)var2_3;
                        yield DoubleWriteGen.LE;
                    }
                    case 4: {
                        JitType.MpIntJitType t = (JitType.MpIntJitType)var2_3;
                        yield MpIntWriteGen.LE;
                    }
                }
                throw new AssertionError();
            }
        };
    }

    public void generateCode(JitCodeGenerator var1, Varnode var2, MethodVisitor var3);
}

