/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import db.DBHandle;
import docking.WindowPosition;
import generic.theme.GIcon;
import ghidra.app.plugin.debug.DbViewerComponent;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DbViewerProvider
extends ComponentProviderAdapter {
    private DBHandle dbh;
    private String dbName;
    private DbViewerComponent comp;

    public DbViewerProvider(Plugin plugin) {
        super(plugin.getTool(), "Database Viewer", plugin.getName());
        this.setIcon((Icon)new GIcon("icon.plugin.debug.dbviewer.provider"));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DbViewer"));
    }

    protected void closeDatabase() {
        if (this.comp != null) {
            this.comp.closeDatabase();
        }
        this.dbh = null;
    }

    protected void openDatabase(String databaseName, DBHandle handle) {
        if (this.comp != null) {
            this.comp.openDatabase(databaseName, handle);
        }
        this.dbh = handle;
        this.dbName = databaseName;
    }

    void refresh() {
        if (this.comp != null) {
            this.comp.refresh();
        }
    }

    void dispose() {
        if (this.comp != null) {
            this.comp.dispose();
            this.comp = null;
        }
    }

    public JComponent getComponent() {
        if (this.comp == null) {
            this.comp = new DbViewerComponent(this.tool);
            if (this.dbh != null) {
                this.comp.openDatabase(this.dbName, this.dbh);
            }
        }
        return this.comp;
    }
}

