/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFLengthValue;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFUnitType;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DWARFUnitHeader {
    protected final DWARFProgram dprog;
    protected final long startOffset;
    protected final long endOffset;
    protected final int intSize;
    protected final short dwarfVersion;
    protected final int unitNumber;

    public static DWARFUnitHeader read(DWARFProgram dprog, BinaryReader reader, BinaryReader abbrReader, int unitNumber, TaskMonitor monitor) throws DWARFException, IOException, CancelledException {
        long startOffset = reader.getPointerIndex();
        DWARFLengthValue lengthInfo = DWARFLengthValue.read(reader, dprog.getDefaultIntSize());
        if (lengthInfo == null) {
            return null;
        }
        long endOffset = reader.getPointerIndex() + lengthInfo.length();
        short version = reader.readNextShort();
        if (version < 2) {
            throw new DWARFException("Unsupported DWARF version [%d]".formatted(version));
        }
        DWARFUnitHeader partial = new DWARFUnitHeader(dprog, startOffset, endOffset, lengthInfo.intSize(), version, unitNumber);
        if (2 <= version && version <= 4) {
            return DWARFCompilationUnit.readV4(partial, reader, abbrReader, monitor);
        }
        int unitType = reader.readNextUnsignedByte();
        switch (unitType) {
            case 1: {
                return DWARFCompilationUnit.readV5(partial, reader, abbrReader, monitor);
            }
        }
        throw new DWARFException("Unsupported unitType %d, %s".formatted(unitType, DWARFUtil.toString(DWARFUnitType.class, unitType)));
    }

    protected DWARFUnitHeader(DWARFUnitHeader other) {
        this.dprog = other.dprog;
        this.startOffset = other.startOffset;
        this.endOffset = other.endOffset;
        this.intSize = other.intSize;
        this.dwarfVersion = other.dwarfVersion;
        this.unitNumber = other.unitNumber;
    }

    protected DWARFUnitHeader(DWARFProgram dprog, long startOffset, long endOffset, int intSize, short version, int unitNumber) {
        this.dprog = dprog;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.intSize = intSize;
        this.dwarfVersion = version;
        this.unitNumber = unitNumber;
    }

    public DWARFProgram getProgram() {
        return this.dprog;
    }

    public short getDWARFVersion() {
        return this.dwarfVersion;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public int getUnitNumber() {
        return this.unitNumber;
    }
}

