/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractLibrarySupportLoader;
import ghidra.app.util.opinion.ElfLoaderOptionsFactory;
import ghidra.app.util.opinion.ElfProgramBuilder;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.options.Options;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ExternalSymbolResolver;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ElfLoader
extends AbstractLibrarySupportLoader {
    public static final String ELF_NAME = "Executable and Linking Format (ELF)";
    public static final String ELF_ENTRY_FUNCTION_NAME = "entry";
    public static final String ELF_FILE_TYPE_PROPERTY = "ELF File Type";
    public static final String ELF_ORIGINAL_IMAGE_BASE_PROPERTY = "ELF Original Image Base";
    public static final String ELF_PRELINKED_PROPERTY = "ELF Prelinked";
    public static final String ELF_SOURCE_FILE_PROPERTY_PREFIX = "ELF Source File [";

    public static Long getElfOriginalImageBase(Program program) {
        Options props = program.getOptions("Program Information");
        String oibStr = props.getString(ELF_ORIGINAL_IMAGE_BASE_PROPERTY, null);
        return oibStr != null ? Long.valueOf(NumericUtilities.parseHexLong((String)oibStr)) : null;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        List<Option> options = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram, mirrorFsLayout);
        try {
            ElfLoaderOptionsFactory.addOptions(options, provider, loadSpec);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)"Error while generating Elf import options", (Throwable)e);
        }
        return options;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        String validationErrorStr;
        if (options != null && (validationErrorStr = ElfLoaderOptionsFactory.validateOptions(loadSpec, options)) != null) {
            return validationErrorStr;
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        try {
            ElfHeader elf = new ElfHeader(provider, null);
            List<QueryResult> results = QueryOpinionService.query(this.getName(), elf.getMachineName(), elf.getFlags());
            for (QueryResult result : results) {
                boolean add = true;
                if (elf.is32Bit() && result.pair.getLanguageDescription().getSize() > 32) {
                    add = false;
                }
                if (elf.is64Bit() && result.pair.getLanguageDescription().getSize() <= 32) {
                    add = false;
                }
                if (elf.isLittleEndian() && result.pair.getLanguageDescription().getEndian() != Endian.LITTLE) {
                    add = false;
                }
                if (elf.isBigEndian() && result.pair.getLanguageDescription().getEndian() != Endian.BIG) {
                    add = false;
                }
                if (!add) continue;
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        catch (ElfException elfException) {
            // empty catch block
        }
        return loadSpecs;
    }

    @Override
    public void load(Program program, Loader.ImporterSettings settings) throws IOException, CancelledException {
        try {
            ElfHeader elf = new ElfHeader(settings.provider(), msg -> settings.log().appendMsg(msg));
            ElfProgramBuilder.loadElf(elf, program, settings.options(), settings.log(), settings.monitor());
        }
        catch (ElfException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) throws CancelledException, IOException {
        super.postLoadProgramFixups(loadedPrograms, settings);
        ProjectData projectData = settings.project() != null ? settings.project().getProjectData() : null;
        try (ExternalSymbolResolver esr = new ExternalSymbolResolver(projectData, settings.monitor());){
            loadedPrograms.forEach(p -> esr.addProgramToFixup((Loaded<Program>)p));
            esr.fixUnresolvedExternalSymbols();
            esr.logInfo(arg_0 -> ((MessageLog)settings.log()).appendMsg(arg_0), true);
        }
    }

    @Override
    public String getName() {
        return ELF_NAME;
    }
}

