/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcodeCPort.slghpatexpress;

import java.io.IOException;

import generic.stl.VectorSTL;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;

public abstract class BinaryExpression extends PatternExpression {

	private PatternExpression left;
	private PatternExpression right;

	public BinaryExpression(Location location) {
		super(location);
		left = null;
		right = null;
	}

	public PatternExpression getLeft() {
		return left;
	}

	public PatternExpression getRight() {
		return right;
	}

	@Override
	public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
		return new TokenPattern(location);
	}

	@Override
	public void listValues(VectorSTL<PatternValue> list) {
		left.listValues(list);
		right.listValues(list);
	}

	@Override
	public void getMinMax(VectorSTL<Long> minlist, VectorSTL<Long> maxlist) {
		left.getMinMax(minlist, maxlist);
		right.getMinMax(minlist, maxlist);
	}

	public BinaryExpression(Location location, PatternExpression l, PatternExpression r) {
		super(location);
		(left = l).layClaim();
		(right = r).layClaim();
	}

	// Delete only non-pattern values
	@Override
	public void dispose() {
		if (left != null) {
			PatternExpression.release(left);
		}
		if (right != null) {
			PatternExpression.release(right);
		}
	}

	// Outer tag is generated by derived classes
	@Override
	public void encode(Encoder encoder) throws IOException {
		left.encode(encoder);
		right.encode(encoder);
	}

}
