/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import generic.util.WindowUtilities;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.MergeManagerPlugin;
import ghidra.app.merge.MergeNavigatable;
import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.ProgramMergeManagerPlugin;
import ghidra.app.merge.ProgramSpecificAddressTranslator;
import ghidra.app.merge.datatypes.DataTypeMergeManager;
import ghidra.app.merge.listing.ExternalProgramMerger;
import ghidra.app.merge.listing.FunctionTagMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.ProgramContextMergeManager;
import ghidra.app.merge.memory.MemoryMergeManager;
import ghidra.app.merge.propertylist.PropertyListMergeManager;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.tool.ListingMergePanelPlugin;
import ghidra.app.merge.tree.ProgramTreeMergeManager;
import ghidra.app.plugin.core.navigation.GoToAddressLabelPlugin;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.ModalPluginTool;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginException;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.listing.DataTypeChangeSet;
import ghidra.program.model.listing.DomainObjectChangeSet;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramChangeSet;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import help.Help;
import help.HelpService;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ProgramMultiUserMergeManager
extends MergeManager {
    private ListingMergePanelPlugin listingPlugin;
    private GoToAddressLabelPlugin goToPlugin;
    private ListingMergePanel mergePanel;
    private boolean isShowingListingMergePanel = false;
    MergeNavigatable navigatable;
    private final boolean showListingPanels = !SystemUtilities.isInTestingBatchMode();

    public ProgramMultiUserMergeManager(Program resultProgram, Program myProgram, Program originalProgram, Program latestProgram, ProgramChangeSet latestChangeSet, ProgramChangeSet myChangeSet) {
        super((DomainObject)resultProgram, (DomainObject)myProgram, (DomainObject)originalProgram, (DomainObject)latestProgram, (DomainObjectChangeSet)latestChangeSet, (DomainObjectChangeSet)myChangeSet);
    }

    @Override
    protected void createMergeResolvers() {
        Program resultProgram = (Program)this.resultDomainObject;
        Program myProgram = (Program)this.myDomainObject;
        Program originalProgram = (Program)this.originalDomainObject;
        Program latestProgram = (Program)this.latestDomainObject;
        int idx = 0;
        this.mergeResolvers = new MergeResolver[8];
        this.mergeResolvers[idx++] = new MemoryMergeManager(this, resultProgram, myProgram, originalProgram, latestProgram);
        this.mergeResolvers[idx++] = new ProgramTreeMergeManager(this, resultProgram, myProgram, originalProgram, latestProgram, (ProgramChangeSet)this.latestChangeSet, (ProgramChangeSet)this.myChangeSet);
        this.mergeResolvers[idx++] = new DataTypeMergeManager(this, (DataTypeManagerDomainObject)resultProgram, (DataTypeManagerDomainObject)myProgram, (DataTypeManagerDomainObject)originalProgram, (DataTypeManagerDomainObject)latestProgram, (DataTypeChangeSet)((ProgramChangeSet)this.latestChangeSet), (DataTypeChangeSet)((ProgramChangeSet)this.myChangeSet));
        this.mergeResolvers[idx++] = new ProgramContextMergeManager(this, resultProgram, originalProgram, latestProgram, myProgram, (ProgramChangeSet)this.latestChangeSet, (ProgramChangeSet)this.myChangeSet);
        this.mergeResolvers[idx++] = new FunctionTagMerger(this, resultProgram, originalProgram, latestProgram, myProgram, (ProgramChangeSet)this.latestChangeSet, (ProgramChangeSet)this.myChangeSet);
        ListingMergeManager listingMergeManager = new ListingMergeManager(this, resultProgram, originalProgram, latestProgram, myProgram, (ProgramChangeSet)this.latestChangeSet, (ProgramChangeSet)this.myChangeSet);
        this.mergeResolvers[idx++] = listingMergeManager;
        this.mergeResolvers[idx++] = new ExternalProgramMerger(this, resultProgram, originalProgram, latestProgram, myProgram, (ProgramChangeSet)this.latestChangeSet, (ProgramChangeSet)this.myChangeSet);
        this.mergeResolvers[idx++] = new PropertyListMergeManager(this, resultProgram, myProgram, originalProgram, latestProgram);
    }

    public Program getProgram(int version) {
        switch (version) {
            case 1: {
                return (Program)this.resultDomainObject;
            }
            case 2: {
                return (Program)this.myDomainObject;
            }
            case 3: {
                return (Program)this.originalDomainObject;
            }
            case 0: {
                return (Program)this.latestDomainObject;
            }
        }
        return null;
    }

    @Override
    protected MergeManagerPlugin createMergeManagerPlugin(ModalPluginTool mergePluginTool, MergeManager multiUserMergeManager, DomainObject modifiableDomainObject) {
        return new ProgramMergeManagerPlugin((PluginTool)this.mergeTool, this, (Program)this.resultDomainObject);
    }

    @Override
    protected void initializeMerge() {
        this.mergePanel = new ListingMergePanel((PluginTool)this.mergeTool, (Program)this.originalDomainObject, (Program)this.resultDomainObject, (Program)this.myDomainObject, (Program)this.latestDomainObject, this.showListingPanels);
        this.mergePanel.removeDomainObjectListener();
        this.navigatable = new MergeNavigatable(this.mergePanel);
        this.mergePanel.addButtonPressedListener(new FieldNavigator((ServiceProvider)this.mergeTool, this.navigatable));
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        this.mergePanel.setPreferredSize(new Dimension(screenDim.width - 200, screenDim.height - 200));
        Dimension d = this.mergePanel.getPreferredSize();
        this.mergeTool.setSize(d.width + 20, d.height + 20);
        Point centerLoc = WindowUtilities.centerOnScreen((Dimension)this.mergeTool.getSize());
        this.mergeTool.setLocation(centerLoc.x, centerLoc.y);
    }

    @Override
    protected void cleanupMerge() {
        this.mergePanel.dispose();
        this.mergePanel = null;
    }

    @Override
    public void showDefaultMergePanel(String description) {
        if (this.isShowingListingMergePanel) {
            this.removeListingMergePanel();
        }
        this.showComponent(null, null, null);
        SwingUtilities.invokeLater(() -> this.mergePlugin.updateMergeDescription(description));
    }

    @Override
    public void showComponent(JComponent comp, String componentID, HelpLocation helpLoc) {
        HelpService help = Help.getHelpService();
        if (helpLoc != null && comp != null) {
            help.registerHelp((Object)comp, helpLoc);
        }
        SwingUtilities.invokeLater(() -> {
            this.showMergeTool();
            Dimension oldSize = this.mergeTool.getSize();
            if (this.listingPlugin != null) {
                this.mergeTool.removePlugins(List.of(this.listingPlugin, this.goToPlugin));
                this.listingPlugin = null;
                this.goToPlugin = null;
            }
            if (comp == null) {
                this.mergePlugin.showDefaultComponent();
            } else {
                this.mergePlugin.setMergeComponent(comp, componentID);
            }
            Dimension newSize = this.mergeTool.getSize();
            if (!newSize.equals(oldSize)) {
                Point centerLoc = WindowUtilities.centerOnScreen((Dimension)this.mergeTool.getSize());
                this.mergeTool.setLocation(centerLoc.x, centerLoc.y);
            }
        });
        if (comp != null) {
            this.inputReceived = false;
            this.waitForInput();
        }
    }

    public void showListingMergePanel(Address goToAddress) {
        SwingUtilities.invokeLater(() -> {
            this.showMergeTool();
            if (this.isShowingListingMergePanel) {
                this.mergePanel.goTo(goToAddress);
                this.mergePanel.validate();
                return;
            }
            this.mergePanel.addDomainObjectListener();
            this.listingPlugin = new ListingMergePanelPlugin((PluginTool)this.mergeTool, this.mergePanel);
            this.goToPlugin = new GoToAddressLabelPlugin((PluginTool)this.mergeTool);
            try {
                this.mergeTool.addPlugin((Plugin)this.listingPlugin);
                this.mergeTool.addPlugin((Plugin)this.goToPlugin);
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
            this.mergePlugin.setMergeComponent(this.mergePanel, "Listing Merge");
            this.mergePanel.goTo(goToAddress);
            this.isShowingListingMergePanel = true;
        });
        this.inputReceived = false;
        this.waitForInput();
    }

    public void refreshListingMergePanel(Address resultAddress, Address latestAddress, Address myAddress, Address originalAddress) {
        SwingUtilities.invokeLater(() -> {
            ProgramSpecificAddressTranslator translator = new ProgramSpecificAddressTranslator();
            translator.addProgramAddress(this.getProgram(0), resultAddress);
            translator.addProgramAddress(this.getProgram(1), latestAddress);
            translator.addProgramAddress(this.getProgram(2), myAddress);
            translator.addProgramAddress(this.getProgram(3), originalAddress);
            this.mergePanel.setAddressTranslator(translator);
            this.mergePanel.goTo(resultAddress, 0);
            this.mergePanel.goTo(latestAddress, 1);
            this.mergePanel.goTo(myAddress, 2);
            this.mergePanel.goTo(originalAddress, 3);
        });
    }

    public void showListingMergePanel(final Address resultAddress, final Address latestAddress, final Address myAddress, final Address originalAddress) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgramMultiUserMergeManager.this.showMergeTool();
                if (!ProgramMultiUserMergeManager.this.isShowingListingMergePanel) {
                    ProgramMultiUserMergeManager.this.mergePanel.addDomainObjectListener();
                    ProgramMultiUserMergeManager.this.listingPlugin = new ListingMergePanelPlugin((PluginTool)ProgramMultiUserMergeManager.this.mergeTool, ProgramMultiUserMergeManager.this.mergePanel);
                    ProgramMultiUserMergeManager.this.goToPlugin = new GoToAddressLabelPlugin((PluginTool)ProgramMultiUserMergeManager.this.mergeTool);
                    try {
                        ProgramMultiUserMergeManager.this.mergeTool.addPlugin((Plugin)ProgramMultiUserMergeManager.this.listingPlugin);
                        ProgramMultiUserMergeManager.this.mergeTool.addPlugin((Plugin)ProgramMultiUserMergeManager.this.goToPlugin);
                    }
                    catch (PluginException e) {
                        e.printStackTrace();
                    }
                    ProgramMultiUserMergeManager.this.mergePlugin.setMergeComponent(ProgramMultiUserMergeManager.this.mergePanel, "Listing Merge");
                }
                this.loadExternalsIntoMergePanel(resultAddress, latestAddress, myAddress, originalAddress);
                ProgramMultiUserMergeManager.this.isShowingListingMergePanel = true;
            }

            private void loadExternalsIntoMergePanel(Address resultAddress2, Address latestAddress2, Address myAddress2, Address originalAddress2) {
                ProgramSpecificAddressTranslator translator = new ProgramSpecificAddressTranslator();
                translator.addProgramAddress(ProgramMultiUserMergeManager.this.getProgram(0), resultAddress2);
                translator.addProgramAddress(ProgramMultiUserMergeManager.this.getProgram(1), latestAddress2);
                translator.addProgramAddress(ProgramMultiUserMergeManager.this.getProgram(2), myAddress2);
                translator.addProgramAddress(ProgramMultiUserMergeManager.this.getProgram(3), originalAddress2);
                ProgramMultiUserMergeManager.this.mergePanel.setAddressTranslator(translator);
                ProgramMultiUserMergeManager.this.mergePanel.goTo(resultAddress2, 0);
                ProgramMultiUserMergeManager.this.mergePanel.goTo(latestAddress2, 1);
                ProgramMultiUserMergeManager.this.mergePanel.goTo(myAddress2, 2);
                ProgramMultiUserMergeManager.this.mergePanel.goTo(originalAddress2, 3);
                ProgramMultiUserMergeManager.this.mergePanel.validate();
            }
        });
        this.inputReceived = false;
        this.waitForInput();
    }

    public void removeListingMergePanel() {
        SwingUtilities.invokeLater(() -> {
            this.showMergeTool();
            if (!this.isShowingListingMergePanel) {
                return;
            }
            this.mergePanel.removeDomainObjectListener();
            ArrayList<Plugin> list = new ArrayList<Plugin>();
            list.add(this.listingPlugin);
            list.add(this.goToPlugin);
            this.mergeTool.removePlugins(list);
            this.isShowingListingMergePanel = false;
            this.mergePlugin.showDefaultComponent();
        });
    }

    public ListingMergePanel getListingMergePanel() {
        return this.mergePanel;
    }

    @Override
    public boolean isMergeToolVisible() {
        return this.mergeToolIsVisible;
    }

    public boolean isShowingListingMergePanel() {
        return this.isShowingListingMergePanel;
    }

    public boolean isShowListingPanel() {
        return this.showListingPanels;
    }
}

