/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import docking.widgets.button.BrowseButton;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFileFilter;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.beans.PropertyEditorSupport;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class ProjectPathChooserEditor
extends PropertyEditorSupport {
    private static final int NUMBER_OF_COLUMNS = 20;
    private JTextField textField = new JTextField(20);
    private MouseListener otherMouseListener;
    private String title;
    private DomainFileFilter filter;

    public ProjectPathChooserEditor(String title, DomainFileFilter filter) {
        this.title = title;
        this.filter = filter;
    }

    @Override
    public String getAsText() {
        return this.textField.getText().trim();
    }

    @Override
    public Object getValue() {
        String text = this.getAsText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        return text;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (text == null || text.trim().isEmpty()) {
            text = "";
        }
        this.textField.setText(text);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setAsText("");
        } else if (value instanceof String) {
            String s = (String)value;
            this.setAsText(s);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new ProjectFileChooserPanel();
    }

    void setMouseListener(MouseListener listener) {
        this.otherMouseListener = listener;
    }

    private class ProjectFileChooserPanel
    extends JPanel {
        private JButton browseButton;

        private ProjectFileChooserPanel() {
            BoxLayout bl = new BoxLayout(this, 0);
            this.setLayout(bl);
            this.browseButton = new BrowseButton();
            this.add(ProjectPathChooserEditor.this.textField);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.browseButton);
            this.setBorder(BorderFactory.createEmptyBorder());
            ProjectPathChooserEditor.this.textField.addActionListener(e -> ProjectPathChooserEditor.this.firePropertyChange());
            ProjectPathChooserEditor.this.textField.getDocument().addDocumentListener(new TextListener());
            this.browseButton.addActionListener(e -> this.displayFileChooser());
            if (ProjectPathChooserEditor.this.otherMouseListener != null) {
                ProjectPathChooserEditor.this.textField.addMouseListener(ProjectPathChooserEditor.this.otherMouseListener);
                this.browseButton.addMouseListener(ProjectPathChooserEditor.this.otherMouseListener);
            }
        }

        private void displayFileChooser() {
            AtomicReference result = new AtomicReference();
            DataTreeDialog dataTreeDialog = new DataTreeDialog(this, ProjectPathChooserEditor.this.title, DataTreeDialogType.OPEN, ProjectPathChooserEditor.this.filter);
            dataTreeDialog.addOkActionListener(e -> {
                dataTreeDialog.close();
                DomainFile df = dataTreeDialog.getDomainFile();
                result.set(df != null ? df.getPathname() : null);
            });
            dataTreeDialog.showComponent();
            String newPath = (String)result.get();
            if (newPath != null) {
                ProjectPathChooserEditor.this.textField.setText(newPath);
                ProjectPathChooserEditor.this.firePropertyChange();
            }
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ProjectPathChooserEditor.this.firePropertyChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ProjectPathChooserEditor.this.firePropertyChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ProjectPathChooserEditor.this.firePropertyChange();
        }
    }
}

