/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.AutoAnalysisManagerListener;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectClosedListener;
import ghidra.program.model.listing.Program;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransientProgramProperties {
    private static final Map<Program, PerProgramProperties> properties = new HashMap<Program, PerProgramProperties>();

    public static synchronized boolean hasProperty(Program program, Object key) {
        PerProgramProperties perProgramProps = properties.get(program);
        return perProgramProps != null ? perProgramProps.props.containsKey(key) : false;
    }

    public static synchronized <T, E extends Throwable> T getProperty(Program program, Object key, SCOPE scope, Class<? extends T> clazz, PropertyValueSupplier<T, E> supplier) throws E {
        if (!(scope != SCOPE.ANALYSIS_SESSION || AutoAnalysisManager.hasAutoAnalysisManager(program) && AutoAnalysisManager.getAnalysisManager(program).isAnalyzing())) {
            throw new IllegalArgumentException("No active analysis session");
        }
        PerProgramProperties perProgramProps = properties.computeIfAbsent(program, PerProgramProperties::new);
        Property property = perProgramProps.props.get(key);
        if (property == null) {
            T supplierVal = supplier.get();
            if (supplierVal == null) {
                return null;
            }
            property = perProgramProps.addProperty(key, supplierVal, scope);
        }
        if (property.scope != scope) {
            throw new IllegalArgumentException("Mismatched Program property scope");
        }
        return clazz.isInstance(property.value) ? (T)clazz.cast(property.value) : null;
    }

    public static synchronized void removeProgramProperties(Program program) {
        PerProgramProperties removedProps = properties.remove(program);
        if (removedProps != null) {
            removedProps.close();
        }
    }

    private static class PerProgramProperties
    implements DomainObjectClosedListener,
    AutoAnalysisManagerListener,
    Closeable {
        final Program program;
        final Map<Object, Property> props;
        boolean aamListenerAdded;

        PerProgramProperties(Program program) {
            this.program = program;
            this.props = new HashMap<Object, Property>();
            program.addCloseListener((DomainObjectClosedListener)this);
        }

        public void domainObjectClosed(DomainObject dobj) {
            TransientProgramProperties.removeProgramProperties(this.program);
        }

        @Override
        public void analysisEnded(AutoAnalysisManager manager, boolean isCancelled) {
            Iterator<Map.Entry<Object, Property>> it = this.props.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Property> entry = it.next();
                Property prop = entry.getValue();
                if (prop.scope != SCOPE.ANALYSIS_SESSION) continue;
                it.remove();
                prop.close();
            }
        }

        @Override
        public void close() {
            this.props.forEach((key, prop) -> prop.close());
            this.props.clear();
            this.program.removeCloseListener((DomainObjectClosedListener)this);
            if (this.aamListenerAdded) {
                AutoAnalysisManager.getAnalysisManager(this.program).removeListener(this);
            }
        }

        private Property addProperty(Object key, Object value, SCOPE scope) {
            if (scope == SCOPE.ANALYSIS_SESSION && !this.aamListenerAdded) {
                AutoAnalysisManager.getAnalysisManager(this.program).addListener(this);
                this.aamListenerAdded = true;
            }
            Property newProperty = new Property(key, value, scope);
            this.props.put(key, newProperty);
            return newProperty;
        }
    }

    public static enum SCOPE {
        PROGRAM,
        ANALYSIS_SESSION;

    }

    private record Property(Object key, Object value, SCOPE scope) implements Closeable
    {
        @Override
        public void close() {
            Object object = this.value;
            if (object instanceof AutoCloseable) {
                AutoCloseable c = (AutoCloseable)object;
                FSUtilities.uncheckedClose(c, null);
            }
        }
    }

    public static interface PropertyValueSupplier<T, E extends Throwable> {
        public T get() throws E;
    }
}

