/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust;

import docking.options.editor.BooleanEditor;
import ghidra.app.plugin.core.analysis.AbstractDemanglerAnalyzer;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemangler;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerFormat;
import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerOptions;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledFunction;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledVariable;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.MangledContext;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.EnumEditor;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.PropertySelector;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Arrays;

public class RustDemanglerAnalyzer
extends AbstractDemanglerAnalyzer {
    private static final String NAME = "Demangler Rust";
    private static final String DESCRIPTION = "Attempt to demangle any symbols mangled by rustc.";
    private static final String OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS = "Demangle Only Known Mangled Symbols";
    private static final String OPTION_DESCRIPTION_USE_KNOWN_PATTERNS = "Only demangle symbols that follow known compiler mangling patterns. Leaving this option off may cause non-mangled symbols to get demangled.";
    private static final String OPTION_NAME_APPLY_CALLING_CONVENTION = "Apply Function Calling Conventions";
    private static final String OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION = "Apply any recovered function signature calling convention";
    static final String OPTION_NAME_USE_DEPRECATED_DEMANGLER = "Use Deprecated Demangler";
    private static final String OPTION_DESCRIPTION_DEPRECATED_DEMANGLER = "Use the deprecated demangler when the modern demangler cannot demangle a given string";
    static final String OPTION_NAME_DEMANGLER_FORMAT = "Demangler Format";
    private static final String OPTION_DESCRIPTION_DEMANGLER_FORMAT = "The demangling format to use";
    private boolean applyCallingConvention = true;
    private boolean demangleOnlyKnownPatterns = true;
    private RustDemanglerFormat demanglerFormat = RustDemanglerFormat.AUTO;
    private boolean useDeprecatedDemangler = false;

    public RustDemanglerAnalyzer() {
        super(NAME, DESCRIPTION);
        this.demangler = new RustDemangler();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before().before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean canAnalyze(Program program) {
        return this.demangler.canDemangle(program);
    }

    @Override
    public void registerOptions(Options options, Program program) {
        HelpLocation help = new HelpLocation("AutoAnalysisPlugin", "Demangler_Analyzer");
        options.registerOption(OPTION_NAME_APPLY_CALLING_CONVENTION, (Object)this.applyCallingConvention, help, OPTION_DESCRIPTION_APPLY_CALLING_CONVENTION);
        options.registerOption(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, (Object)this.demangleOnlyKnownPatterns, help, OPTION_DESCRIPTION_USE_KNOWN_PATTERNS);
        RustOptionsEditor optionsEditor = new RustOptionsEditor();
        options.registerOption(OPTION_NAME_USE_DEPRECATED_DEMANGLER, OptionType.BOOLEAN_TYPE, (Object)this.useDeprecatedDemangler, help, OPTION_DESCRIPTION_DEPRECATED_DEMANGLER, () -> optionsEditor.getDeprecatedNameEditor());
        options.registerOption(OPTION_NAME_DEMANGLER_FORMAT, OptionType.ENUM_TYPE, (Object)this.demanglerFormat, help, OPTION_DESCRIPTION_DEMANGLER_FORMAT, () -> optionsEditor.getFormatEditor());
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.applyCallingConvention = options.getBoolean(OPTION_NAME_APPLY_CALLING_CONVENTION, this.applyCallingConvention);
        this.demangleOnlyKnownPatterns = options.getBoolean(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, this.demangleOnlyKnownPatterns);
        this.demanglerFormat = (RustDemanglerFormat)options.getEnum(OPTION_NAME_DEMANGLER_FORMAT, (Enum)RustDemanglerFormat.AUTO);
        this.useDeprecatedDemangler = options.getBoolean(OPTION_NAME_USE_DEPRECATED_DEMANGLER, this.useDeprecatedDemangler);
    }

    @Override
    protected DemanglerOptions getOptions() {
        RustDemanglerOptions options = new RustDemanglerOptions(this.demanglerFormat, this.useDeprecatedDemangler);
        options.setDoDisassembly(true);
        options.setApplyCallingConvention(this.applyCallingConvention);
        options.setDemangleOnlyKnownPatterns(this.demangleOnlyKnownPatterns);
        return options;
    }

    @Override
    protected DemangledObject doDemangle(MangledContext mangledContext, MessageLog log) throws DemangledException {
        return this.demangler.demangle(mangledContext);
    }

    @Override
    protected void apply(MangledContext mangledContext, DemangledObject demangled, MessageLog log, TaskMonitor monitor) {
        try {
            if (demangled instanceof DemangledFunction) {
                DemangledFunction defunc = (DemangledFunction)demangled;
                defunc.applyTo(mangledContext.getProgram(), mangledContext.getAddress(), mangledContext.getOptions(), monitor);
                return;
            }
        }
        catch (Exception defunc) {
            // empty catch block
        }
        String mangled = demangled.getMangledString();
        String original = demangled.getOriginalDemangled();
        String name = demangled.getName();
        Demangled namespace = demangled.getNamespace();
        DemangledVariable demangledVariable = new DemangledVariable(mangled, original, name);
        demangledVariable.setNamespace(namespace);
        super.apply(mangledContext, demangledVariable, log, monitor);
    }

    private class RustOptionsEditor {
        private BooleanEditor deprecatedEditor;
        private FormatEditor formatEditor;

        private RustOptionsEditor() {
        }

        private void lazyInit() {
            if (SystemUtilities.isInHeadlessMode()) {
                return;
            }
            if (this.deprecatedEditor != null) {
                return;
            }
            this.deprecatedEditor = new BooleanEditor();
            this.deprecatedEditor.setValue((Object)RustDemanglerAnalyzer.this.useDeprecatedDemangler);
            this.formatEditor = new FormatEditor(RustDemanglerAnalyzer.this.demanglerFormat, this.deprecatedEditor);
            this.deprecatedEditor.addPropertyChangeListener((PropertyChangeListener)this.formatEditor);
        }

        PropertyEditor getDeprecatedNameEditor() {
            this.lazyInit();
            return this.deprecatedEditor;
        }

        PropertyEditor getFormatEditor() {
            this.lazyInit();
            return this.formatEditor;
        }
    }

    private static class FormatSelector
    extends PropertySelector {
        public FormatSelector(FormatEditor fe) {
            super((PropertyEditor)((Object)fe));
        }

        void reset(String[] tags) {
            this.removeAllItems();
            for (String tag : tags) {
                this.addItem(tag);
            }
        }

        RustDemanglerFormat getFormat() {
            return RustDemanglerFormat.valueOf((String)this.getSelectedItem());
        }

        void setFormat(RustDemanglerFormat format) {
            this.setSelectedItem(format.name());
        }
    }

    private static class FormatEditor
    extends EnumEditor
    implements PropertyChangeListener {
        private final FormatSelector selector;
        private final BooleanEditor isDeprecated;

        FormatEditor(RustDemanglerFormat value, BooleanEditor isDeprecated) {
            this.setValue((Object)value);
            this.isDeprecated = isDeprecated;
            this.selector = new FormatSelector(this);
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public FormatSelector getCustomEditor() {
            return this.selector;
        }

        public RustDemanglerFormat[] getEnums() {
            return (RustDemanglerFormat[])Arrays.stream(RustDemanglerFormat.values()).filter(this::filter).toArray(RustDemanglerFormat[]::new);
        }

        public String[] getTags() {
            return (String[])Arrays.stream(RustDemanglerFormat.values()).filter(this::filter).map(Enum::name).toArray(String[]::new);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RustDemanglerFormat format = this.selector.getFormat();
            this.selector.reset(this.getTags());
            if (format.isAvailable(this.isDeprecatedDemangler())) {
                this.setValue((Object)format);
                this.selector.setFormat(format);
            } else {
                this.setValue((Object)RustDemanglerFormat.AUTO);
            }
        }

        private boolean isDeprecatedDemangler() {
            return (Boolean)this.isDeprecated.getValue();
        }

        private boolean filter(RustDemanglerFormat f) {
            return f.isAvailable(this.isDeprecatedDemangler());
        }
    }
}

