/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import ghidra.app.cmd.function.CreateMultipleFunctionsCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.ProgramSelection;

class CreateMultipleFunctionsAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    CreateMultipleFunctionsAction(String name, FunctionPlugin plugin) {
        super(name, plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{name}, null, "Function", -1, "A_Beginning"));
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        if (!this.isEnabledForContext(context)) {
            return;
        }
        Program currentProgram = context.getProgram();
        if (currentProgram == null) {
            return;
        }
        CreateMultipleFunctionsCmd cmd = new CreateMultipleFunctionsCmd(selection, SourceType.USER_DEFINED);
        this.funcPlugin.execute(currentProgram, cmd);
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        return context.hasSelection();
    }
}

