/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFIndirectTableHeader;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class DWARFIndirectTable {
    private final BinaryReader reader;
    private final Map<Long, DWARFIndirectTableHeader> lookupMap = new HashMap<Long, DWARFIndirectTableHeader>();
    private final Function<DWARFCompilationUnit, Long> baseOffsetFunc;

    public DWARFIndirectTable(BinaryReader reader, Function<DWARFCompilationUnit, Long> baseOffsetFunc) {
        this.reader = reader;
        this.baseOffsetFunc = baseOffsetFunc;
    }

    public void bootstrap(String msg, CheckedIOFunction<BinaryReader, ? extends DWARFIndirectTableHeader> headerReader, TaskMonitor monitor) throws CancelledException, IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.setPointerIndex(0);
        monitor.initialize(this.reader.length(), msg);
        while (this.reader.hasNext()) {
            monitor.checkCancelled();
            monitor.setProgress(this.reader.getPointerIndex());
            monitor.setMessage(msg + " #" + this.lookupMap.size());
            DWARFIndirectTableHeader header = headerReader.apply(this.reader);
            if (header == null) continue;
            this.lookupMap.put(header.getFirstElementOffset(), header);
        }
    }

    public long getOffset(int index, DWARFCompilationUnit cu) throws IOException {
        long base = this.baseOffsetFunc.apply(cu);
        DWARFIndirectTableHeader header = this.lookupMap.get(base);
        if (header == null) {
            throw new IOException("Invalid base %d for compUnit %x".formatted(base, cu.getStartOffset()));
        }
        return header.getOffset(index, this.reader);
    }

    public void clear() {
        this.lookupMap.clear();
    }

    public static interface CheckedIOFunction<T, R> {
        public R apply(T var1) throws IOException;
    }
}

