/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.program.model.pcode.Varnode;
import java.util.Arrays;

public class DWARFLocation {
    private DWARFRange addressRange;
    private byte[] expr;
    private Varnode resolvedValue;

    public DWARFLocation(long start, long end, byte[] expr) {
        this(new DWARFRange(start, end), expr);
    }

    public DWARFLocation(DWARFRange addressRange, byte[] expr) {
        this.addressRange = addressRange;
        this.expr = expr;
    }

    public DWARFRange getRange() {
        return this.addressRange;
    }

    public byte[] getExpr() {
        return this.expr;
    }

    public boolean isWildcard() {
        return this.addressRange == null;
    }

    public long getOffset(long pc) {
        return this.addressRange != null ? this.addressRange.getFrom() - pc : 0L;
    }

    public boolean contains(long addr) {
        return this.isWildcard() || this.addressRange.contains(addr);
    }

    public Varnode getResolvedValue() {
        return this.resolvedValue;
    }

    public void setResolvedValue(Varnode resolvedValue) {
        this.resolvedValue = resolvedValue;
    }

    public String toString() {
        return "DWARFLocation: range: %s, expr: %s".formatted(this.addressRange, Arrays.toString(this.expr));
    }
}

