/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.VariableOpenCloseField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariablesOpenCloseLocation;
import java.math.BigInteger;

public class VariablesOpenCloseFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "+";

    public VariablesOpenCloseFieldFactory() {
        super(FIELD_NAME);
    }

    private VariablesOpenCloseFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.servicesChanged();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        VariableProxy variableProxy;
        if (!this.enabled) {
            return null;
        }
        if (proxy instanceof VariableProxy && (variableProxy = (VariableProxy)proxy).isFirst()) {
            return new VariableOpenCloseField(this, proxy, this.getMetrics(), this.startX + varWidth, this.width);
        }
        return null;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj<?> proxy = bf.getProxy();
        if (proxy instanceof VariableProxy) {
            VariableProxy variableProxy = (VariableProxy)proxy;
            Program program = variableProxy.getProgram();
            Address functionAddress = variableProxy.getFunctionAddress();
            return new VariablesOpenCloseLocation(program, functionAddress);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof VariablesOpenCloseLocation)) {
            return null;
        }
        return new FieldLocation(index, fieldNum, 0, 0);
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!Variable.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 3;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel fieldModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new VariablesOpenCloseFieldFactory(fieldModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

