/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.LinkedGhidraFolder;
import ghidra.framework.data.NullFolderDomainObject;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.util.Msg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;

public class FolderLinkContentHandler
extends LinkHandler<NullFolderDomainObject> {
    public static FolderLinkContentHandler INSTANCE = new FolderLinkContentHandler();
    public static final String FOLDER_LINK_CONTENT_TYPE = "FolderLink";

    @Override
    public String getContentType() {
        return FOLDER_LINK_CONTENT_TYPE;
    }

    @Override
    public String getContentTypeDisplayString() {
        return FOLDER_LINK_CONTENT_TYPE;
    }

    @Override
    public Class<NullFolderDomainObject> getDomainObjectClass() {
        return NullFolderDomainObject.class;
    }

    @Override
    public Icon getIcon() {
        return DomainFolder.CLOSED_FOLDER_ICON;
    }

    @Override
    public String getDefaultToolName() {
        return null;
    }

    public static LinkedGhidraFolder getLinkedFolder(DomainFile folderLinkFile) throws IOException {
        LinkFileInfo linkInfo = folderLinkFile.getLinkInfo();
        if (linkInfo == null || !linkInfo.isFolderLink()) {
            return null;
        }
        AtomicReference linkStatus = new AtomicReference();
        AtomicReference errMsg = new AtomicReference();
        DomainFile folderLink = LinkHandler.followInternalLinkage(folderLinkFile, s -> linkStatus.set(s), err -> errMsg.set(err));
        LinkHandler.LinkStatus s2 = (LinkHandler.LinkStatus)((Object)linkStatus.get());
        if (s2 == LinkHandler.LinkStatus.BROKEN) {
            String msg = (String)errMsg.get();
            if (msg == null) {
                msg = "Unable to follow broken link";
            }
            throw new IOException(msg + ": " + String.valueOf(folderLink));
        }
        if (s2 == LinkHandler.LinkStatus.EXTERNAL) {
            Project activeProject = AppInfo.getActiveProject();
            if (activeProject == null) {
                Msg.error(FolderLinkContentHandler.class, (Object)"Use of Linked Folders requires an active project.");
                return null;
            }
            return new LinkedGhidraFolder(folderLink, FolderLinkContentHandler.getLinkURL(folderLink));
        }
        if (folderLink != null) {
            ProjectData projectData;
            DomainFolder parent = folderLink.getParent();
            if (parent instanceof LinkedDomainFolder) {
                LinkedDomainFolder lf = (LinkedDomainFolder)parent;
                try {
                    projectData = lf.getLinkedProjectData();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unexpected", e);
                }
            } else {
                projectData = parent.getProjectData();
            }
            String linkPath = LinkHandler.getAbsoluteLinkPath(folderLink);
            DomainFolder linkedFolder = projectData.getFolder(linkPath);
            if (linkedFolder != null) {
                return new LinkedGhidraFolder(folderLinkFile, linkedFolder);
            }
        }
        throw new FileNotFoundException("Invalid folder-link: " + String.valueOf(folderLinkFile));
    }
}

