/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectDBTransaction;
import ghidra.framework.data.DomainObjectTransactionManager;
import ghidra.framework.model.AbortedTransactionListener;
import ghidra.framework.model.TransactionInfo;
import java.io.IOException;
import java.util.ArrayList;

class SynchronizedTransaction
implements TransactionInfo {
    private DomainObjectTransactionManager[] managers;
    private int[] holdTransactionIds;
    private boolean[] hasChanges;
    private String[] descriptions;
    private int[] activeCounts;
    private TransactionInfo.Status status = TransactionInfo.Status.NOT_DONE;
    private final long id;

    SynchronizedTransaction(DomainObjectTransactionManager[] managers) {
        this.managers = managers;
        this.holdTransactionIds = new int[managers.length];
        this.hasChanges = new boolean[managers.length];
        this.descriptions = new String[managers.length];
        this.activeCounts = new int[managers.length];
        this.id = DomainObjectDBTransaction.getNextBaseId();
        for (int i = 0; i < managers.length; ++i) {
            DomainObjectTransactionManager mgr = managers[i];
            this.holdTransactionIds[i] = mgr.startTransaction(mgr.getDomainObject(), "", null, false, false);
        }
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.managers.length; ++i) {
            if (this.descriptions[i] == null) continue;
            if (buf.length() != 0) {
                buf.append('\n');
            }
            buf.append(this.getDomainObjectName(this.managers[i]));
            buf.append(": ");
            buf.append(this.descriptions[i]);
        }
        return buf.toString();
    }

    private String getDomainObjectName(DomainObjectTransactionManager manager) {
        DomainObjectAdapterDB domainObject = manager.getDomainObject();
        return domainObject.getDomainFile().getName();
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public ArrayList<String> getOpenSubTransactions() {
        ArrayList<String> list = new ArrayList<String>();
        TransactionInfo.Status status = this.getStatus();
        if (status == TransactionInfo.Status.ABORTED || status == TransactionInfo.Status.COMMITTED) {
            return list;
        }
        for (int i = 0; i < this.managers.length; ++i) {
            String name = this.getDomainObjectName(this.managers[i]);
            for (String str : this.managers[i].getCurrentTransactionInfo().getOpenSubTransactions()) {
                list.add(name + ": " + str);
            }
        }
        return list;
    }

    private boolean isActive() {
        for (int activeCount : this.activeCounts) {
            if (activeCount == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public TransactionInfo.Status getStatus() {
        if (this.status == TransactionInfo.Status.ABORTED && this.isActive()) {
            return TransactionInfo.Status.NOT_DONE_BUT_ABORTED;
        }
        return this.status;
    }

    int addEntry(DomainObjectAdapterDB domainObj, String description, AbortedTransactionListener listener) {
        int index = this.findDomainObject(domainObj);
        int txId = this.managers[index].startTransaction(domainObj, description, listener, false, false);
        int n = index;
        this.activeCounts[n] = this.activeCounts[n] + 1;
        if (this.descriptions[index] == null && description != null && description.length() != 0) {
            this.descriptions[index] = description;
        }
        return txId;
    }

    void endEntry(DomainObjectAdapterDB domainObj, int transactionID, boolean commit) {
        int index = this.findDomainObject(domainObj);
        this.managers[index].endTransaction(domainObj, transactionID, commit, false);
        if (!commit) {
            this.status = TransactionInfo.Status.ABORTED;
        }
        int n = index;
        this.activeCounts[n] = this.activeCounts[n] - 1;
        if (!this.isActive() && this.status == TransactionInfo.Status.NOT_DONE) {
            this.status = TransactionInfo.Status.COMMITTED;
        }
    }

    private int findDomainObject(DomainObjectAdapterDB domainObj) {
        for (int i = 0; i < this.managers.length; ++i) {
            if (this.managers[i].getDomainObject() != domainObj) continue;
            return i;
        }
        throw new IllegalStateException("unknown domain object");
    }

    boolean endAll(boolean commit) {
        boolean hasChange = false;
        for (int i = 0; i < this.managers.length; ++i) {
            TransactionInfo transaction = this.managers[i].endTransaction(this.managers[i].getDomainObject(), this.holdTransactionIds[i], commit, false);
            if (commit && transaction.hasCommittedDBTransaction()) {
                this.hasChanges[i] = true;
                hasChange = true;
                continue;
            }
            this.descriptions[i] = null;
        }
        return hasChange;
    }

    void redo() throws IOException {
        for (int i = 0; i < this.managers.length; ++i) {
            if (!this.hasChanges[i]) continue;
            this.managers[i].doRedo(false);
        }
    }

    void undo() throws IOException {
        for (int i = 0; i < this.managers.length; ++i) {
            if (!this.hasChanges[i]) continue;
            this.managers[i].doUndo(false);
        }
    }

    @Override
    public boolean hasCommittedDBTransaction() {
        for (int i = 0; i < this.managers.length; ++i) {
            if (!this.hasChanges[i]) continue;
            return true;
        }
        return false;
    }
}

