/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.wizard.project;

import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.main.wizard.project.ProjectWizardModel;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import utility.function.Callback;

public class SelectProjectPanel
extends JPanel {
    private static String PROJECT_EXTENSION = ProjectLocator.getProjectExtension().substring(1);
    private JTextField projectNameField;
    private JTextField directoryField;
    private JButton browseButton;
    private Callback statusChangedCallback;

    public SelectProjectPanel(Callback statusChangedCallback) {
        super((LayoutManager)new PairLayout(10, 10));
        this.setBorder(ProjectWizardModel.STANDARD_BORDER);
        this.statusChangedCallback = statusChangedCallback;
        this.buildMainPanel();
    }

    void setProjectName(String projectName) {
        this.projectNameField.setText(projectName);
    }

    String getProjectName() {
        String name = this.projectNameField.getText().trim();
        if (name.endsWith(PROJECT_EXTENSION)) {
            name = name.substring(0, name.length() - PROJECT_EXTENSION.length());
        }
        return name;
    }

    String getDirectoryName() {
        return this.directoryField.getText().trim();
    }

    private void buildMainPanel() {
        DocumentListener documentListener = this.createDocumentListener();
        this.add((Component)new GDLabel("Project Directory:", 4));
        this.add(this.createDirectoryPanel(documentListener));
        this.add((Component)new GDLabel("Project Name:", 4));
        this.add(this.createProjectNameField(documentListener));
    }

    private JTextField createProjectNameField(DocumentListener documentListener) {
        this.projectNameField = new JTextField(10);
        this.projectNameField.setName("Project Name");
        this.projectNameField.addActionListener(e -> this.statusChangedCallback.call());
        this.projectNameField.getDocument().addDocumentListener(documentListener);
        return this.projectNameField;
    }

    private JPanel createDirectoryPanel(DocumentListener listener) {
        JPanel panel = new JPanel(new BorderLayout());
        this.directoryField = new JTextField(10);
        this.directoryField.getDocument().addDocumentListener(listener);
        this.directoryField.setName("Project Directory");
        File projectDirectory = null;
        String projectDirPath = Preferences.getProperty((String)"LastNewProjectDirectory");
        if (projectDirPath != null && !(projectDirectory = new File(projectDirPath)).isDirectory()) {
            projectDirectory = null;
        }
        if (projectDirectory == null) {
            projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
        }
        projectDirPath = projectDirectory.getAbsolutePath();
        this.directoryField.setText(projectDirPath);
        this.directoryField.setCaretPosition(projectDirPath.length() - 1);
        this.browseButton = new BrowseButton();
        this.browseButton.addActionListener(e -> this.displayFileChooser());
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        buttonPanel.add((Component)this.browseButton, "Center");
        panel.add((Component)this.directoryField, "Center");
        panel.add((Component)buttonPanel, "East");
        return panel;
    }

    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectProjectPanel.this.statusChangedCallback.call();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectProjectPanel.this.statusChangedCallback.call();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectProjectPanel.this.statusChangedCallback.call();
            }
        };
    }

    private void displayFileChooser() {
        GhidraFileChooser fileChooser = this.createFileChooser();
        fileChooser.setTitle("Select a Ghidra Project Directory");
        fileChooser.setApproveButtonText("Select Project Directory");
        fileChooser.setApproveButtonToolTipText("Select a Ghidra Project Directory");
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            this.directoryField.setText(file.getAbsolutePath());
            this.statusChangedCallback.call();
        }
        fileChooser.dispose();
    }

    private GhidraFileChooser createFileChooser() {
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this);
        File projectDirectory = new File(GenericRunInfo.getProjectsDirPath());
        String lastDirSelected = Preferences.getProperty((String)"LastNewProjectDirectory", null, (boolean)true);
        if (lastDirSelected != null) {
            projectDirectory = new File(lastDirSelected);
        }
        fileChooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
        fileChooser.setFileFilter(new GhidraFileFilter(this){

            public String getDescription() {
                return "All Directories";
            }

            public boolean accept(File f, GhidraFileChooserModel model) {
                return model.isDirectory(f) && !f.getName().endsWith(ProjectLocator.getProjectDirExtension());
            }
        });
        fileChooser.setCurrentDirectory(projectDirectory);
        return fileChooser;
    }
}

