/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat.quickmethod;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class QuickMethodFrameInfo
implements StructConverter {
    static final int SIZE = 12;
    private int frame_size_in_bytes_;
    private int core_spill_mask_;
    private int fp_spill_mask_;

    QuickMethodFrameInfo(BinaryReader reader) throws IOException {
        this.frame_size_in_bytes_ = reader.readNextInt();
        this.core_spill_mask_ = reader.readNextInt();
        this.fp_spill_mask_ = reader.readNextInt();
    }

    public int getFrameSizeInBytes() {
        return this.frame_size_in_bytes_;
    }

    public int getCoreSpillMask() {
        return this.core_spill_mask_;
    }

    public int getFpSpillMask() {
        return this.fp_spill_mask_;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(QuickMethodFrameInfo.class);
        dataType.setCategoryPath(new CategoryPath("/oat"));
        return dataType;
    }
}

