/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Token
implements StructConverter {
    public static final String NAME = "MINIDUMP_TOKEN";
    private int tokenSize;
    private int tokenId;
    private long tokenHandle;
    private DumpFileReader reader;
    private long index;

    Token(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setTokenSize(this.reader.readNextInt());
        this.setTokenId(this.reader.readNextInt());
        this.setTokenHandle(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "Size", null);
        struct.add(DWORD, 4, "Id", null);
        struct.add(QWORD, 8, "Handle", null);
        return struct;
    }

    public int getTokenSize() {
        return this.tokenSize;
    }

    public void setTokenSize(int tokenSize) {
        this.tokenSize = tokenSize;
    }

    public int getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(int tokenId) {
        this.tokenId = tokenId;
    }

    public long getTokenHandle() {
        return this.tokenHandle;
    }

    public void setTokenHandle(long tokenHandle) {
        this.tokenHandle = tokenHandle;
    }
}

