/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashBasicDirectoryInode;
import ghidra.file.formats.squashfs.SquashDirectoryTableEntry;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;
import java.util.Date;

public class SquashInode {
    private final short inodeType;
    private final short permissions;
    private final int userID;
    private final int groupID;
    private final long modTime;
    private final int inodeNumber;
    private SquashInode parent = null;
    private SquashDirectoryTableEntry directoryTableEntry;

    public SquashInode(BinaryReader reader, SquashSuperBlock superBlock) throws IOException {
        this.inodeType = reader.readNextShort();
        this.permissions = reader.readNextShort();
        this.userID = reader.readNextUnsignedShort();
        this.groupID = reader.readNextUnsignedShort();
        this.modTime = reader.readNextUnsignedInt();
        this.inodeNumber = reader.readNextUnsignedIntExact();
    }

    public short getPermissions() {
        return this.permissions;
    }

    public short getType() {
        return this.inodeType;
    }

    public int getUserID() {
        return this.userID;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public long getModTime() {
        return this.modTime;
    }

    public Date getModTimeAsDate() {
        return new Date(this.modTime * 1000L);
    }

    public int getNumber() {
        return this.inodeNumber;
    }

    void setParent(SquashInode parentInode) {
        this.parent = parentInode;
    }

    public SquashBasicDirectoryInode getParent() {
        if (!this.parent.isDir()) {
            return null;
        }
        return (SquashBasicDirectoryInode)this.parent;
    }

    void setDirectoryTableEntry(SquashDirectoryTableEntry entry) {
        this.directoryTableEntry = entry;
    }

    public SquashDirectoryTableEntry getDirectoryTableEntry() {
        return this.directoryTableEntry;
    }

    public boolean isDir() {
        return this.inodeType == 1 || this.inodeType == 8;
    }

    public boolean isFile() {
        return this.inodeType == 2 || this.inodeType == 9;
    }

    public boolean isSymLink() {
        return this.inodeType == 3 || this.inodeType == 10;
    }
}

