/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighFunctionShellSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;

public class RenameGlobalAction
extends AbstractDecompilerAction {
    public RenameGlobalAction() {
        super("Rename Global");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameGlobal"));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Global"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return false;
        }
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        if (highSymbol == null || highSymbol instanceof HighFunctionShellSymbol) {
            return false;
        }
        return highSymbol.isGlobal();
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        CodeSymbol symbol = null;
        AddEditDialog dialog = new AddEditDialog("Rename Global", context.getTool());
        if (highSymbol instanceof HighCodeSymbol && (symbol = ((HighCodeSymbol)highSymbol).getCodeSymbol()) == null) {
            Address addr = ((HighCodeSymbol)highSymbol).getStorage().getMinAddress();
            SymbolTable symbolTable = context.getProgram().getSymbolTable();
            symbol = symbolTable.getPrimarySymbol(addr);
            if (symbol == null) {
                dialog.addLabel(addr, context.getProgram());
                return;
            }
        }
        if (symbol == null) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Rename Failed", (Object)"Memory storage not found for global variable");
            return;
        }
        dialog.editLabel((Symbol)symbol, context.getProgram());
    }
}

