/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.HandleTemplate;
import ghidra.app.plugin.processors.generic.OpTemplate;
import ghidra.app.plugin.processors.generic.Operand;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.app.plugin.processors.generic.SledException;
import ghidra.app.plugin.processors.generic.VarnodeTemplate;
import ghidra.program.model.pcode.PcodeOp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstructorPcodeTemplate
implements Serializable {
    private HandleTemplate result;
    private ArrayList<Object> pcodeDirectives = new ArrayList();
    private int delaySlotDepth;
    private int flowFlags;

    public void addPcodeOpTemplate(Object opT) throws SledException {
        if (opT.getClass() == HandleTemplate.class) {
            this.result = (HandleTemplate)opT;
        } else {
            if (opT.getClass() == Integer.class) {
                if (this.delaySlotDepth == 0) {
                    this.delaySlotDepth = (Integer)opT;
                } else {
                    throw new SledException("only one delay slot directive is allowed in a constructor");
                }
            }
            this.pcodeDirectives.add(opT);
        }
    }

    public void trimToSize() {
        this.pcodeDirectives.trimToSize();
    }

    public void optimize() {
        this.flowFlags = 0;
        for (int i = 0; i < this.pcodeDirectives.size(); ++i) {
            Operand ref;
            VarnodeTemplate vt;
            OpTemplate op;
            try {
                op = (OpTemplate)this.pcodeDirectives.get(i);
            }
            catch (ClassCastException e) {
                continue;
            }
            this.adjustFlowFlags(op);
            if (op.opcode() == 2) {
                if (!op.output().oneuse() || (vt = op.input(1)).space().type() != 2 || vt.offset().type() != 2 || vt.size().type() != 2) continue;
                ref = vt.space().operand();
                if (vt.offset().operand() != ref || vt.size().operand() != ref) continue;
                op.output().setReplace(ref, true);
                op.setOmit(ref);
                continue;
            }
            if (op.opcode() != 3 || !op.input(2).oneuse() || op.input(2).loadomit() || (vt = op.input(1)).space().type() != 2 || vt.offset().type() != 2 || vt.size().type() != 2) continue;
            ref = vt.space().operand();
            if (vt.offset().operand() != ref || vt.size().operand() != ref) continue;
            op.input(2).setReplace(ref, false);
            op.setOmit(ref);
        }
    }

    private void adjustFlowFlags(OpTemplate op) throws SledException {
        if ((this.flowFlags & 0x20) != 0) {
            throw new SledException("Template contains dead code");
        }
        switch (op.opcode()) {
            case 4: {
                int destType = op.input(0).offset().type();
                if (destType == 4) {
                    this.flowFlags |= 0x60;
                    break;
                }
                if (destType == 3) {
                    this.flowFlags |= 0x20;
                    break;
                }
                this.flowFlags |= 0x30;
                break;
            }
            case 6: {
                this.flowFlags |= 0x24;
                break;
            }
            case 7: {
                this.flowFlags |= 8;
                break;
            }
            case 8: {
                this.flowFlags |= 2;
                break;
            }
            case 5: {
                int destType = op.input(0).offset().type();
                if (destType == 4) {
                    this.flowFlags |= 0x40;
                    break;
                }
                if (destType == 3) break;
                this.flowFlags |= 0x10;
                break;
            }
            case 10: {
                this.flowFlags |= 0x21;
                break;
            }
        }
    }

    public int getFlowFlags() {
        return this.flowFlags;
    }

    public Handle getPcode(ArrayList<PcodeOp> pcode, Position position, int off, ArrayList<PcodeOp> delayPcode) throws Exception {
        HashMap<Object, Handle> handles = new HashMap<Object, Handle>();
        for (int i = 0; i < this.pcodeDirectives.size(); ++i) {
            Object o = this.pcodeDirectives.get(i);
            if (o.getClass() == OpTemplate.class) {
                if (((OpTemplate)o).omit()) continue;
                pcode.add(((OpTemplate)o).getPcode(handles, position, pcode.size(), off));
                continue;
            }
            if (o.getClass() == Operand.class) {
                Handle ht = ((Operand)o).getHandle(pcode, position, off);
                if (ht == null) continue;
                handles.put(o, ht);
                continue;
            }
            if (o.getClass() == Integer.class) {
                if (delayPcode != null) {
                    pcode.addAll(delayPcode);
                    continue;
                }
                throw new SledException("delay slot code requested at inappropriate level of constructor tree");
            }
            throw new SledException("Invalid pcode directive");
        }
        if (this.result == null) {
            return null;
        }
        return this.result.resolve(handles, position, off);
    }

    public int delaySlotDepth() {
        return this.delaySlotDepth;
    }

    public HandleTemplate result() {
        return this.result;
    }
}

